/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.certvalidator.structure;

import java.util.Arrays;
import java.util.List;
import network.oxalis.commons.certvalidator.api.ValidatorRule;
import network.oxalis.commons.certvalidator.structure.AndJunction;
import network.oxalis.commons.certvalidator.structure.OrJunction;
import network.oxalis.commons.certvalidator.structure.XorJunction;

public interface Junction {
    public static ValidatorRule and(ValidatorRule ... validatorRules) {
        return Junction.and(Arrays.asList(validatorRules));
    }

    public static ValidatorRule and(List<ValidatorRule> validatorRules) {
        if (validatorRules.size() == 1) {
            return validatorRules.get(0);
        }
        return new AndJunction(validatorRules);
    }

    public static ValidatorRule or(ValidatorRule ... validatorRules) {
        return Junction.or(Arrays.asList(validatorRules));
    }

    public static ValidatorRule or(List<ValidatorRule> validatorRules) {
        if (validatorRules.size() == 1) {
            return validatorRules.get(0);
        }
        return new OrJunction(validatorRules);
    }

    public static ValidatorRule xor(ValidatorRule ... validatorRules) {
        return Junction.xor(Arrays.asList(validatorRules));
    }

    public static ValidatorRule xor(List<ValidatorRule> validatorRules) {
        if (validatorRules.size() == 1) {
            return validatorRules.get(0);
        }
        return new XorJunction(validatorRules);
    }
}

