/*
 * Decompiled with CFR 0.152.
 */
package network.nerve.heterogeneous;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;
import network.nerve.heterogeneous.context.BnbContext;
import network.nerve.heterogeneous.core.BNBWalletApi;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class BSCTool {
    private static BNBWalletApi bnbWalletApi = BNBWalletApi.getInstance();

    public static void init(String rpcAddress) {
        BnbContext.rpcAddress = rpcAddress;
        bnbWalletApi.restartApi();
    }

    public static String transferBnb(String fromAddress, String privateKey, String toAddress, BigDecimal amount, BigInteger gasLimit, BigInteger gasPrice) throws Exception {
        return bnbWalletApi.sendBNB(fromAddress, privateKey, toAddress, amount, gasLimit, gasPrice);
    }

    public static EthSendTransaction transferBep20(String fromAddress, String privateKey, String toAddress, BigInteger amount, String contractAddress, BigInteger gasLimit, BigInteger gasPrice) throws Exception {
        return bnbWalletApi.transferERC20Token(fromAddress, toAddress, amount, privateKey, contractAddress, gasLimit, gasPrice);
    }

    public static BigDecimal getBnbBalance(String address) throws Exception {
        return bnbWalletApi.getBalance(address);
    }

    public static BigInteger getBep20Balance(String address, String contractAddress) throws Exception {
        return bnbWalletApi.getERC20Balance(address, contractAddress);
    }

    public static String rechargeBnb(String fromAddress, String privateKey, BigInteger value, String toAddress, String multySignContractAddress) throws Exception {
        return bnbWalletApi.rechargeBnb(fromAddress, privateKey, value, toAddress, multySignContractAddress);
    }

    public static String rechargeBep20(String fromAddress, String privateKey, BigInteger value, String toAddress, String multySignContractAddress, String bep20ContractAddress) throws Exception {
        return bnbWalletApi.rechargeBep20(fromAddress, privateKey, value, toAddress, multySignContractAddress, bep20ContractAddress);
    }

    public static String authorization(String fromAddress, String privateKey, String multySignContractAddress, String bep20ContractAddress) throws Exception {
        return bnbWalletApi.authorization(fromAddress, privateKey, multySignContractAddress, bep20ContractAddress);
    }

    public static boolean isAuthorized(String fromAddress, String multySignContractAddress, String bep20ContractAddress) throws Exception {
        return bnbWalletApi.isAuthorized(fromAddress, multySignContractAddress, bep20ContractAddress);
    }

    public static List<Type> callViewFunction(String contractAddress, Function function) throws Exception {
        return bnbWalletApi.callViewFunction(contractAddress, function);
    }

    public static TransactionReceipt getTxReceipt(String txHash) throws Exception {
        return bnbWalletApi.getTxReceipt(txHash);
    }

    public static int getContractTokenDecimals(String tokenContract) throws Exception {
        return bnbWalletApi.getContractTokenDecimals(tokenContract);
    }

    public static BigInteger totalSupply(String contractAddress) throws Exception {
        return bnbWalletApi.totalSupply(contractAddress);
    }

    public static BigInteger getCurrentGasPrice() throws IOException {
        return bnbWalletApi.getCurrentGasPrice();
    }

    public static BigDecimal calNVTOfWithdraw(BigDecimal nvtUSD, BigDecimal gasPrice, BigDecimal ethUSD, boolean isBNBToken) {
        BigDecimal gasLimit = isBNBToken ? BigDecimal.valueOf(210000L) : BigDecimal.valueOf(190000L);
        BigDecimal nvtAmount = BSCTool.calNVTByGasPrice(nvtUSD, gasPrice, ethUSD, gasLimit);
        nvtAmount = nvtAmount.divide(BigDecimal.TEN.pow(8), 0, RoundingMode.UP).movePointRight(8);
        return nvtAmount;
    }

    public static BigDecimal calNVTByGasPrice(BigDecimal nvtUSD, BigDecimal gasPrice, BigDecimal ethUSD, BigDecimal gasLimit) {
        BigDecimal nvtAmount = ethUSD.multiply(gasPrice).multiply(gasLimit).divide(nvtUSD.multiply(BigDecimal.TEN.pow(10)), 0, RoundingMode.UP);
        return nvtAmount;
    }
}

