/*
 * Decompiled with CFR 0.152.
 */
package network.finschia.sdk.crypto;

import com.codahale.xsalsa20poly1305.SecretBox;
import java.util.Arrays;
import java.util.Optional;
import network.finschia.sdk.crypto.SecureRandomUtils;

public final class Xsalsa20Symmetric {
    private static final int NONCE_LEN = 24;
    private static final int SECRET_KEY_LEN = 32;

    private Xsalsa20Symmetric() {
    }

    static byte[] encryptSymmetric(byte[] plaintext, byte[] secretKey) {
        Xsalsa20Symmetric.checkSecretKeyLength(secretKey);
        byte[] nonce = new byte[24];
        SecureRandomUtils.secureRandom().nextBytes(nonce);
        SecretBox box = new SecretBox(secretKey);
        byte[] res = box.seal(nonce, plaintext);
        byte[] out = new byte[nonce.length + res.length];
        System.arraycopy(nonce, 0, out, 0, nonce.length);
        System.arraycopy(res, 0, out, nonce.length, res.length);
        return out;
    }

    static byte[] decryptSymmetric(byte[] cipherText, byte[] secretKey) {
        Xsalsa20Symmetric.checkSecretKeyLength(secretKey);
        byte[] nonce = Arrays.copyOfRange(cipherText, 0, 24);
        byte[] cipher = Arrays.copyOfRange(cipherText, 24, cipherText.length);
        SecretBox box = new SecretBox(secretKey);
        Optional plaintext = box.open(nonce, cipher);
        if (plaintext.isPresent()) {
            return (byte[])plaintext.get();
        }
        throw new RuntimeException("Ciphertext decryption failed");
    }

    private static void checkSecretKeyLength(byte[] secretKey) {
        if (secretKey.length != 32) {
            throw new IllegalArgumentException(String.format("Secret must be 32 bytes long, got len %d", secretKey.length));
        }
    }
}

