/*
 * Decompiled with CFR 0.152.
 */
package network.finschia.sdk.crypto;

import java.io.IOException;
import java.io.OutputStream;
import java.util.TreeMap;
import org.bouncycastle.bcpg.CRC24;
import org.bouncycastle.util.Strings;

public class TendermintArmoredOutputStream
extends OutputStream {
    private static final byte[] encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    final OutputStream out;
    final int[] buf = new int[3];
    int bufPtr;
    final CRC24 crc = new CRC24();
    int chunkCount;
    boolean start = true;
    String nl = Strings.lineSeparator();
    static final String headerStart = "-----BEGIN TENDERMINT PRIVATE KEY";
    static final String headerTail = "-----";
    static final String footerStart = "-----END TENDERMINT PRIVATE KEY";
    static final String footerTail = "-----";
    final TreeMap<String, String> headers = new TreeMap();

    private static void encode(OutputStream out, int[] data, int len) throws IOException {
        switch (len) {
            case 0: {
                break;
            }
            case 1: {
                int d1 = data[0];
                out.write(encodingTable[d1 >>> 2 & 0x3F]);
                out.write(encodingTable[d1 << 4 & 0x3F]);
                out.write(61);
                out.write(61);
                break;
            }
            case 2: {
                int d1 = data[0];
                int d2 = data[1];
                out.write(encodingTable[d1 >>> 2 & 0x3F]);
                out.write(encodingTable[(d1 << 4 | d2 >>> 4) & 0x3F]);
                out.write(encodingTable[d2 << 2 & 0x3F]);
                out.write(61);
                break;
            }
            case 3: {
                int d1 = data[0];
                int d2 = data[1];
                int d3 = data[2];
                out.write(encodingTable[d1 >>> 2 & 0x3F]);
                out.write(encodingTable[(d1 << 4 | d2 >>> 4) & 0x3F]);
                out.write(encodingTable[(d2 << 2 | d3 >>> 6) & 0x3F]);
                out.write(encodingTable[d3 & 0x3F]);
                break;
            }
            default: {
                throw new IOException("unknown length in encode");
            }
        }
    }

    public TendermintArmoredOutputStream(OutputStream out) {
        this.out = out;
        if (this.nl == null) {
            this.nl = "\r\n";
        }
    }

    public void setHeader(String name, String value) {
        if (value == null) {
            this.headers.remove(name);
        } else {
            this.headers.put(name, value);
        }
    }

    private void writeHeaderEntry(String name, String value) throws IOException {
        int i;
        for (i = 0; i != name.length(); ++i) {
            this.out.write(name.charAt(i));
        }
        this.out.write(58);
        this.out.write(32);
        for (i = 0; i != value.length(); ++i) {
            this.out.write(value.charAt(i));
        }
        for (i = 0; i != this.nl.length(); ++i) {
            this.out.write(this.nl.charAt(i));
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.start) {
            Object[] hashkeys;
            this.writeString(headerStart);
            this.writeString("-----");
            this.writeString(this.nl);
            for (Object o : hashkeys = this.headers.keySet().toArray()) {
                String key = (String)o;
                this.writeHeaderEntry(key, this.headers.get(key));
            }
            this.writeString(this.nl);
            this.start = false;
        }
        if (this.bufPtr == 3) {
            TendermintArmoredOutputStream.encode(this.out, this.buf, this.bufPtr);
            this.bufPtr = 0;
            if ((++this.chunkCount & 0xF) == 0) {
                for (int i = 0; i != this.nl.length(); ++i) {
                    this.out.write(this.nl.charAt(i));
                }
            }
        }
        this.crc.update(b);
        this.buf[this.bufPtr++] = b & 0xFF;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        TendermintArmoredOutputStream.encode(this.out, this.buf, this.bufPtr);
        this.writeString(this.nl);
        this.out.write(61);
        int crcV = this.crc.getValue();
        this.buf[0] = crcV >> 16 & 0xFF;
        this.buf[1] = crcV >> 8 & 0xFF;
        this.buf[2] = crcV & 0xFF;
        TendermintArmoredOutputStream.encode(this.out, this.buf, 3);
        this.writeString(this.nl);
        this.writeString(footerStart);
        this.writeString("-----");
        this.writeString(this.nl);
        this.out.flush();
        this.start = true;
    }

    private void writeString(String content) throws IOException {
        for (int i = 0; i != content.length(); ++i) {
            this.out.write(content.charAt(i));
        }
    }
}

