/*
 * Decompiled with CFR 0.152.
 */
package network.finschia.sdk.crypto;

import at.favre.lib.crypto.bcrypt.BCrypt;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import network.finschia.sdk.crypto.Amino;
import network.finschia.sdk.crypto.SecureRandomUtils;
import network.finschia.sdk.crypto.TendermintArmoredOutputStream;
import network.finschia.sdk.crypto.Xsalsa20Symmetric;
import org.apache.commons.io.output.WriterOutputStream;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.jcajce.provider.digest.SHA256;
import org.bouncycastle.openpgp.PGPUtil;

public final class KeyStore {
    private static final int BCRYPT_SECURITY_PARAMETER = 12;
    private static final int SALT_BYTES_SIZE = 16;
    private static final String PRIV_KEY_TYPE_SECP256K1 = "tendermint/PrivKeySecp256k1";
    private static final Charset US_ASCII_CHARSET = StandardCharsets.US_ASCII;
    private static final BaseEncoding BASE16 = BaseEncoding.base16();
    static final String KDF_TYPE = "bcrypt";
    final String kdf;
    final byte[] armoredPrivateKey;
    final byte[] salt;

    private KeyStore(String kdf, byte[] salt, byte[] armoredPrivateKey) {
        if (!KDF_TYPE.equals(kdf)) {
            throw new IllegalArgumentException(String.format("Unrecognized KDF type: %s", kdf));
        }
        if (salt.length == 0) {
            throw new IllegalArgumentException("Missing salt bytes");
        }
        this.kdf = kdf;
        this.salt = salt;
        this.armoredPrivateKey = armoredPrivateKey;
    }

    public byte[] getPrivateKey(String passphrase) {
        return this.unarmorPrivateKey(passphrase);
    }

    private byte[] unarmorPrivateKey(String password) {
        byte[] bcryptKey = BCrypt.withDefaults().hash(12, this.salt, password.getBytes(StandardCharsets.UTF_8));
        byte[] encryptedKey = new SHA256.Digest().digest(bcryptKey);
        byte[] privateKeyBytes = Xsalsa20Symmetric.decryptSymmetric(this.armoredPrivateKey, encryptedKey);
        return Amino.removeAminoPrefix(privateKeyBytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String export() {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.export(out);
            String string = new String(out.toByteArray(), US_ASCII_CHARSET);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to export keystore", e);
        }
    }

    public void export(Writer writer) {
        try (WriterOutputStream out = new WriterOutputStream(writer, US_ASCII_CHARSET);){
            this.export((OutputStream)out);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to export keystore", e);
        }
    }

    public void export(OutputStream out) {
        try (TendermintArmoredOutputStream tOut = new TendermintArmoredOutputStream(out);){
            tOut.setHeader("salt", BASE16.lowerCase().encode(this.salt));
            tOut.setHeader("kdf", this.kdf);
            tOut.write(this.armoredPrivateKey);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to export keystore", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore load(Reader keyStoreData) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(CharStreams.toString((Readable)keyStoreData).getBytes(US_ASCII_CHARSET));){
            KeyStore keyStore = KeyStore.decode(in);
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to decode keystore data", e);
        }
    }

    public static KeyStore load(InputStream keystoreData) {
        try {
            return KeyStore.decode(keystoreData);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to decode keystore data", e);
        }
    }

    private static KeyStore decode(InputStream in) throws IOException {
        ArmoredInputStream armored = (ArmoredInputStream)PGPUtil.getDecoderStream((InputStream)in);
        Map<String, String> headers = KeyStore.parseHeader(armored.getArmorHeaders());
        return new KeyStore(headers.get("kdf"), BASE16.decode((CharSequence)headers.get("salt").toUpperCase()), ByteStreams.toByteArray((InputStream)armored));
    }

    private static Map<String, String> parseHeader(String[] headers) {
        return Arrays.stream(headers).map(Pattern.compile(": ")::split).collect(Collectors.toMap(s -> s[0], s -> s[1]));
    }

    public static KeyStore createFromPrivateKey(byte[] privateKey, String password) {
        byte[] salt = KeyStore.generateRandomBytes(16);
        return new KeyStore(KDF_TYPE, salt, KeyStore.armorPrivateKey(privateKey, password, salt));
    }

    private static byte[] generateRandomBytes(int size) {
        byte[] bytes = new byte[size];
        SecureRandomUtils.secureRandom().nextBytes(bytes);
        return bytes;
    }

    private static byte[] armorPrivateKey(byte[] privateKey, String password, byte[] salt) {
        byte[] bcryptKey = BCrypt.withDefaults().hash(12, salt, password.getBytes(StandardCharsets.UTF_8));
        byte[] encryptedKey = new SHA256.Digest().digest(bcryptKey);
        byte[] encodedPrivateKey = Amino.addAminoPrefix(PRIV_KEY_TYPE_SECP256K1, privateKey);
        return Xsalsa20Symmetric.encryptSymmetric(encodedPrivateKey, encryptedKey);
    }
}

