/*
 * Decompiled with CFR 0.152.
 */
package network.finschia.sdk.crypto;

import com.google.common.primitives.Bytes;
import java.util.Arrays;
import org.bitcoinj.core.VarInt;
import org.bouncycastle.jcajce.provider.digest.SHA256;

public final class Amino {
    private static final int DISAMBIGUATION_BYTE_LENGTH = 3;
    private static final int TYPE_PREFIX_LENGTH = 4;
    private static final int SECP256K1_KEY_SIZE_PREFIX_LENGTH = 1;
    private static final int SECP256K1_KEY_AMINO_PREFIX_LEN = 5;
    private static final int SECP256K1_KEY_SIZE = 33;

    public static byte[] addAminoPrefix(String name, byte[] body) {
        byte[] prefix = Amino.makeAminoPrefix(name, body);
        return Bytes.concat((byte[][])new byte[][]{prefix, body});
    }

    private Amino() {
    }

    static byte[] makeAminoPrefix(String name, byte[] body) {
        byte[] hash = new SHA256.Digest().digest(name.getBytes());
        int disambiguationByteStart = Amino.getNonZeroValueIndex(hash);
        int typePrefixStart = Amino.getNonZeroValueIndex(hash, disambiguationByteStart + 3, hash.length);
        if (body.length > 33) {
            throw new IllegalArgumentException(String.format("The body size is %d bytes. Currently, amino encoding is only supported for secp256k1 keys.", body.length));
        }
        byte[] sizePrefix = new VarInt((long)body.length).encode();
        return Bytes.concat((byte[][])new byte[][]{Arrays.copyOfRange(hash, typePrefixStart, typePrefixStart + 4), sizePrefix});
    }

    public static byte[] removeAminoPrefix(byte[] bytes) {
        return Arrays.copyOfRange(bytes, 5, bytes.length);
    }

    public static byte[] removeAminoPrefix(byte[] bytes, int bytesLen) {
        return Arrays.copyOfRange(bytes, 5, 5 + bytesLen);
    }

    static int getNonZeroValueIndex(byte[] hash) {
        return Amino.getNonZeroValueIndex(hash, 0, hash.length);
    }

    static int getNonZeroValueIndex(byte[] hash, int start, int end) {
        if (start < 0 || end > hash.length) {
            throw new IllegalArgumentException(String.format("Invalid index (start: %d, end: %d, length: %d)", start, end, hash.length));
        }
        for (int i = start; i < end; ++i) {
            if (hash[i] == 0) continue;
            return i;
        }
        throw new IllegalArgumentException("input hash is empty");
    }
}

