/*
 * Decompiled with CFR 0.152.
 */
package network.finschia.sdk.account;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import network.finschia.sdk.account.Type;
import network.finschia.sdk.common.TypedValue;
import network.finschia.sdk.crypto.Amino;
import network.finschia.sdk.crypto.Bech32Utils;
import network.finschia.sdk.crypto.LinkKeys;
import org.bitcoinj.core.Bech32;
import org.bouncycastle.util.encoders.Hex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u0019\b\u0017\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u0007J\u0006\u0010\u001d\u001a\u00020\tJ\b\u0010\u001e\u001a\u00020\tH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lnetwork/finschia/sdk/account/PubKey;", "", "type", "Lnetwork/finschia/sdk/account/Type;", "body", "", "(Lnetwork/finschia/sdk/account/Type;[B)V", "([B)V", "bech32pubKey", "", "hrpPrefix", "(Ljava/lang/String;Ljava/lang/String;)V", "getBody", "()[B", "encodingType", "getEncodingType", "()Ljava/lang/String;", "getType", "()Lnetwork/finschia/sdk/account/Type;", "asTypedValue", "Lnetwork/finschia/sdk/common/TypedValue;", "checkBodySize", "", "equals", "", "other", "hashCode", "", "toBech32", "toHexString", "toString", "Companion", "crypto"})
public final class PubKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Type type;
    @NotNull
    private final String encodingType;
    @NotNull
    private final byte[] body;
    @NotNull
    private static final String BECH32_HRP_SUFFIX = "pub";
    @NotNull
    private static final String PUB_KEY_TYPE_SECP256K1 = "tendermint/PubKeySecp256k1";
    public static final int PUBLIC_KEY_SIZE_IN_BYTE = 33;

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @NotNull
    public final String getEncodingType() {
        return this.encodingType;
    }

    @NotNull
    public final byte[] getBody() {
        return this.body;
    }

    public PubKey(@NotNull Type type, @NotNull byte[] body) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.encodingType = PUB_KEY_TYPE_SECP256K1;
        this.type = type;
        this.body = body;
        this.checkBodySize();
    }

    public PubKey(@NotNull byte[] body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this(Type.ACCOUNT, body);
    }

    @JvmOverloads
    public PubKey(@NotNull String bech32pubKey, @NotNull String hrpPrefix) {
        Intrinsics.checkNotNullParameter((Object)bech32pubKey, (String)"bech32pubKey");
        Intrinsics.checkNotNullParameter((Object)hrpPrefix, (String)"hrpPrefix");
        this.encodingType = PUB_KEY_TYPE_SECP256K1;
        Bech32.Bech32Data bech32Data = Bech32.decode((String)bech32pubKey);
        String string = bech32Data.hrp;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bech32Data.hrp");
        boolean bl = StringsKt.startsWith$default((String)string, (String)hrpPrefix, (boolean)false, (int)2, null);
        int n = 0;
        int n2 = 0;
        if (!bl) {
            boolean bl2 = false;
            String string2 = "Illegal HRP prefix('" + bech32Data.hrp + "' does not start with '" + hrpPrefix + "')";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        String string3 = bech32Data.hrp;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"bech32Data.hrp");
        boolean bl3 = StringsKt.endsWith$default((String)string3, (String)BECH32_HRP_SUFFIX, (boolean)false, (int)2, null);
        n = 0;
        n2 = 0;
        if (!bl3) {
            boolean bl4 = false;
            String string4 = "Illegal HRP suffix('" + bech32Data.hrp + "' does not end with 'pub')";
            throw (Throwable)new IllegalArgumentException(string4.toString());
        }
        String string5 = bech32Data.hrp;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"bech32Data.hrp");
        n = hrpPrefix.length();
        n2 = bech32Data.hrp.length() - BECH32_HRP_SUFFIX.length();
        boolean bl5 = false;
        String string6 = string5.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        this.type = Type.Companion.invoke(string6);
        byte[] aminoEncodedBody = Bech32Utils.convertBits(bech32Data.data, 0, bech32Data.data.length, 5, 8, true);
        byte[] byArray = Amino.removeAminoPrefix(aminoEncodedBody, 33);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"removeAminoPrefix(aminoEncodedBody, PUBLIC_KEY_SIZE_IN_BYTE)");
        this.body = byArray;
        this.checkBodySize();
    }

    public /* synthetic */ PubKey(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "link";
        }
        this(string, string2);
    }

    private final void checkBodySize() {
        int bodySize = this.body.length;
        boolean bl = bodySize == 33;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "public key is 33 bytes, but input is " + bodySize + " bytes";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final TypedValue<byte[]> asTypedValue() {
        return new TypedValue<byte[]>(this.encodingType, this.body);
    }

    @JvmOverloads
    @NotNull
    public final String toBech32(@NotNull String hrpPrefix) {
        Intrinsics.checkNotNullParameter((Object)hrpPrefix, (String)"hrpPrefix");
        byte[] byArray = Amino.addAminoPrefix(this.encodingType, this.body);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"addAminoPrefix(encodingType, body)");
        byte[] encodedBody = byArray;
        byte[] bech32data = Bech32Utils.convertBits(encodedBody, 0, encodedBody.length, 8, 5, true);
        String hrp = hrpPrefix + Type.Companion.toHrpPrefix(this.type) + BECH32_HRP_SUFFIX;
        String string = Bech32.encode((String)hrp, (byte[])bech32data);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(hrp, bech32data)");
        return string;
    }

    public static /* synthetic */ String toBech32$default(PubKey pubKey, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "link";
        }
        return pubKey.toBech32(string);
    }

    @NotNull
    public final String toHexString() {
        String string = Hex.toHexString((byte[])this.body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(body)");
        return string;
    }

    @NotNull
    public String toString() {
        return PubKey.toBech32$default(this, null, 1, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type network.finschia.sdk.account.PubKey");
        }
        PubKey cfr_ignored_0 = (PubKey)other;
        if (this.type != ((PubKey)other).type) return false;
        object = this.body;
        byte[] byArray = ((PubKey)other).body;
        boolean bl = false;
        if (!Arrays.equals((byte[])object, byArray)) return false;
        return true;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        byte[] byArray = this.body;
        boolean bl = false;
        result = 31 * result + Arrays.hashCode(byArray);
        return result;
    }

    @JvmOverloads
    public PubKey(@NotNull String bech32pubKey) {
        Intrinsics.checkNotNullParameter((Object)bech32pubKey, (String)"bech32pubKey");
        this(bech32pubKey, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final String toBech32() {
        return PubKey.toBech32$default(this, null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final PubKey createFromPrivateKey(@NotNull byte[] privateKey) {
        return Companion.createFromPrivateKey(privateKey);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnetwork/finschia/sdk/account/PubKey$Companion;", "", "()V", "BECH32_HRP_SUFFIX", "", "PUBLIC_KEY_SIZE_IN_BYTE", "", "PUB_KEY_TYPE_SECP256K1", "createFromPrivateKey", "Lnetwork/finschia/sdk/account/PubKey;", "privateKey", "", "crypto"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PubKey createFromPrivateKey(@NotNull byte[] privateKey) {
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            byte[] byArray = LinkKeys.getPublicKey(privateKey, true);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getPublicKey(privateKey, true)");
            return new PubKey(byArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

