/*
 * Decompiled with CFR 0.152.
 */
package network.finschia.sdk.account;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import network.finschia.sdk.account.Address;
import network.finschia.sdk.account.PubKey;
import network.finschia.sdk.account.Wallet;
import network.finschia.sdk.crypto.ECDSASignature;
import network.finschia.sdk.crypto.KeyStore;
import network.finschia.sdk.crypto.LinkKeys;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u000f\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lnetwork/finschia/sdk/account/KeyWallet;", "Lnetwork/finschia/sdk/account/Wallet;", "privateKey", "", "([B)V", "address", "Lnetwork/finschia/sdk/account/Address;", "getAddress", "()Lnetwork/finschia/sdk/account/Address;", "getPrivateKey", "()[B", "pubKey", "Lnetwork/finschia/sdk/account/PubKey;", "getPubKey", "()Lnetwork/finschia/sdk/account/PubKey;", "exportKeyStore", "", "keyStoreData", "Ljava/io/OutputStream;", "passphrase", "", "Ljava/io/Writer;", "sign", "message", "Companion", "crypto"})
public final class KeyWallet
implements Wallet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] privateKey;
    @NotNull
    private final PubKey pubKey;
    @NotNull
    private final Address address;

    private KeyWallet(byte[] privateKey) {
        this.privateKey = privateKey;
        this.pubKey = PubKey.Companion.createFromPrivateKey(this.privateKey);
        this.address = Address.Companion.of(this.getPubKey());
    }

    @NotNull
    public final byte[] getPrivateKey() {
        return this.privateKey;
    }

    @Override
    @NotNull
    public PubKey getPubKey() {
        return this.pubKey;
    }

    @Override
    @NotNull
    public Address getAddress() {
        return this.address;
    }

    @Override
    @NotNull
    public byte[] sign(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ECDSASignature signature = new ECDSASignature(this.privateKey);
        BigInteger[] sig = signature.generateSignature(message);
        byte[] byArray = signature.recoverableSerialize(sig, message);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"signature.recoverableSerialize(sig, message)");
        return byArray;
    }

    @NotNull
    public final String exportKeyStore(@NotNull String passphrase) {
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        String string = KeyStore.createFromPrivateKey(this.privateKey, passphrase).export();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"createFromPrivateKey(privateKey, passphrase).export()");
        return string;
    }

    public final void exportKeyStore(@NotNull OutputStream keyStoreData, @NotNull String passphrase) {
        Intrinsics.checkNotNullParameter((Object)keyStoreData, (String)"keyStoreData");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        KeyStore.createFromPrivateKey(this.privateKey, passphrase).export(keyStoreData);
    }

    public final void exportKeyStore(@NotNull Writer keyStoreData, @NotNull String passphrase) {
        Intrinsics.checkNotNullParameter((Object)keyStoreData, (String)"keyStoreData");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        KeyStore.createFromPrivateKey(this.privateKey, passphrase).export(keyStoreData);
    }

    @JvmStatic
    @NotNull
    public static final KeyWallet create() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        return Companion.create();
    }

    @JvmStatic
    @NotNull
    public static final KeyWallet loadFromPrivateKey(@NotNull byte[] privateKey) {
        return Companion.loadFromPrivateKey(privateKey);
    }

    @JvmStatic
    @NotNull
    public static final KeyWallet loadFromKeyStore(@NotNull Reader keyStoreData, @NotNull String passphrase) {
        return Companion.loadFromKeyStore(keyStoreData, passphrase);
    }

    @JvmStatic
    @NotNull
    public static final KeyWallet loadFromKeyStore(@NotNull InputStream keyStoreData, @NotNull String passphrase) {
        return Companion.loadFromKeyStore(keyStoreData, passphrase);
    }

    public /* synthetic */ KeyWallet(byte[] privateKey, DefaultConstructorMarker $constructor_marker) {
        this(privateKey);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lnetwork/finschia/sdk/account/KeyWallet$Companion;", "", "()V", "create", "Lnetwork/finschia/sdk/account/KeyWallet;", "loadFromKeyStore", "keyStoreData", "Ljava/io/InputStream;", "passphrase", "", "Ljava/io/Reader;", "loadFromPrivateKey", "privateKey", "", "crypto"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KeyWallet create() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
            byte[] byArray = LinkKeys.createPrivateKey();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"createPrivateKey()");
            return new KeyWallet(byArray, null);
        }

        @JvmStatic
        @NotNull
        public final KeyWallet loadFromPrivateKey(@NotNull byte[] privateKey) {
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            return new KeyWallet(privateKey, null);
        }

        @JvmStatic
        @NotNull
        public final KeyWallet loadFromKeyStore(@NotNull Reader keyStoreData, @NotNull String passphrase) {
            Intrinsics.checkNotNullParameter((Object)keyStoreData, (String)"keyStoreData");
            Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
            byte[] byArray = KeyStore.load(keyStoreData).getPrivateKey(passphrase);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"load(keyStoreData).getPrivateKey(passphrase)");
            return new KeyWallet(byArray, null);
        }

        @JvmStatic
        @NotNull
        public final KeyWallet loadFromKeyStore(@NotNull InputStream keyStoreData, @NotNull String passphrase) {
            Intrinsics.checkNotNullParameter((Object)keyStoreData, (String)"keyStoreData");
            Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
            byte[] byArray = KeyStore.load(keyStoreData).getPrivateKey(passphrase);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"load(keyStoreData).getPrivateKey(passphrase)");
            return new KeyWallet(byArray, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

