/*
 * Decompiled with CFR 0.152.
 */
package network.finschia.sdk.account;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import network.finschia.sdk.account.KeyWallet;
import network.finschia.sdk.crypto.Bip44WalletUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lnetwork/finschia/sdk/account/HDWallet;", "", "mnemonic", "", "(Ljava/lang/String;)V", "getMnemonic", "()Ljava/lang/String;", "getKeyWallet", "Lnetwork/finschia/sdk/account/KeyWallet;", "lbmAccountNumber", "", "index", "Companion", "crypto"})
public final class HDWallet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String mnemonic;

    private HDWallet(String mnemonic) {
        this.mnemonic = mnemonic;
    }

    @NotNull
    public final String getMnemonic() {
        return this.mnemonic;
    }

    @JvmOverloads
    @NotNull
    public final KeyWallet getKeyWallet(int lbmAccountNumber, int index) {
        byte[] byArray = Bip44WalletUtils.generatePrivateKey(this.mnemonic, lbmAccountNumber, index);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"generatePrivateKey(mnemonic, lbmAccountNumber, index)");
        return KeyWallet.Companion.loadFromPrivateKey(byArray);
    }

    public static /* synthetic */ KeyWallet getKeyWallet$default(HDWallet hDWallet, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return hDWallet.getKeyWallet(n, n2);
    }

    @JvmOverloads
    @NotNull
    public final KeyWallet getKeyWallet(int lbmAccountNumber) {
        return HDWallet.getKeyWallet$default(this, lbmAccountNumber, 0, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final KeyWallet getKeyWallet() {
        return HDWallet.getKeyWallet$default(this, 0, 0, 3, null);
    }

    @JvmStatic
    @NotNull
    public static final HDWallet create() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        return Companion.create();
    }

    @JvmStatic
    @NotNull
    public static final HDWallet loadFromMnemonic(@NotNull String mnemonic) {
        return Companion.loadFromMnemonic(mnemonic);
    }

    public /* synthetic */ HDWallet(String mnemonic, DefaultConstructorMarker $constructor_marker) {
        this(mnemonic);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lnetwork/finschia/sdk/account/HDWallet$Companion;", "", "()V", "create", "Lnetwork/finschia/sdk/account/HDWallet;", "loadFromMnemonic", "mnemonic", "", "crypto"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HDWallet create() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
            String string = Bip44WalletUtils.generateMnemonic();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateMnemonic()");
            return new HDWallet(string, null);
        }

        @JvmStatic
        @NotNull
        public final HDWallet loadFromMnemonic(@NotNull String mnemonic) {
            Intrinsics.checkNotNullParameter((Object)mnemonic, (String)"mnemonic");
            return new HDWallet(mnemonic, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

