/*
 * Decompiled with CFR 0.152.
 */
package network.finschia.sdk.account;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import network.finschia.sdk.account.PubKey;
import network.finschia.sdk.account.Type;
import network.finschia.sdk.crypto.Bech32Utils;
import org.bitcoinj.core.Bech32;
import org.bouncycastle.jcajce.provider.digest.RIPEMD160;
import org.bouncycastle.jcajce.provider.digest.SHA256;
import org.bouncycastle.util.encoders.Hex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0011H\u0007J\u0006\u0010\u0013\u001a\u00020\u0011J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lnetwork/finschia/sdk/account/Address;", "", "type", "Lnetwork/finschia/sdk/account/Type;", "body", "", "(Lnetwork/finschia/sdk/account/Type;[B)V", "getBody", "()[B", "getType", "()Lnetwork/finschia/sdk/account/Type;", "equals", "", "other", "hashCode", "", "toBech32", "", "hrpPrefix", "toHexString", "toString", "Companion", "crypto"})
public final class Address {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Type type;
    @NotNull
    private final byte[] body;
    private static final int ADDRESS_SIZE_IN_BYTE = 20;
    @JvmField
    @NotNull
    public static final Address EMPTY_ADDRESS = new Address(Type.ACCOUNT, new byte[0]);

    private Address(Type type, byte[] body) {
        this.type = type;
        this.body = body;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @NotNull
    public final byte[] getBody() {
        return this.body;
    }

    @JvmOverloads
    @NotNull
    public final String toBech32(@NotNull String hrpPrefix) {
        Intrinsics.checkNotNullParameter((Object)hrpPrefix, (String)"hrpPrefix");
        byte[] byArray = this.body;
        boolean bl = false;
        if (byArray.length == 0) {
            return "";
        }
        byte[] bech32data = Bech32Utils.convertBits(this.body, 0, this.body.length, 8, 5, true);
        String string = Bech32.encode((String)Intrinsics.stringPlus((String)hrpPrefix, (Object)Type.Companion.toHrpPrefix(this.type)), (byte[])bech32data);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(\"${hrpPrefix}${type.toHrpPrefix()}\", bech32data)");
        return string;
    }

    public static /* synthetic */ String toBech32$default(Address address, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "link";
        }
        return address.toBech32(string);
    }

    @NotNull
    public final String toHexString() {
        String string = Hex.toHexString((byte[])this.body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(body)");
        return string;
    }

    @NotNull
    public String toString() {
        return Address.toBech32$default(this, null, 1, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type network.finschia.sdk.account.Address");
        }
        Address cfr_ignored_0 = (Address)other;
        if (this.type != ((Address)other).type) return false;
        object = this.body;
        byte[] byArray = ((Address)other).body;
        boolean bl = false;
        if (!Arrays.equals((byte[])object, byArray)) return false;
        return true;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        byte[] byArray = this.body;
        boolean bl = false;
        result = 31 * result + Arrays.hashCode(byArray);
        return result;
    }

    @JvmOverloads
    @NotNull
    public final String toBech32() {
        return Address.toBech32$default(this, null, 1, null);
    }

    @JvmStatic
    @JvmName(name="of")
    @NotNull
    public static final Address of(@NotNull Type type, @NotNull byte[] body) {
        return Companion.of(type, body);
    }

    @JvmStatic
    @JvmName(name="of")
    @NotNull
    public static final Address of(@NotNull byte[] body) {
        return Companion.of(body);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="of")
    @NotNull
    public static final Address of(@NotNull String bech32Address, @NotNull String hrpPrefix) {
        return Companion.of(bech32Address, hrpPrefix);
    }

    @JvmStatic
    @JvmName(name="of")
    @NotNull
    public static final Address of(@NotNull PubKey pubKey) {
        return Companion.of(pubKey);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="of")
    @NotNull
    public static final Address of(@NotNull String bech32Address) {
        return Companion.of(bech32Address);
    }

    public /* synthetic */ Address(Type type, byte[] body, DefaultConstructorMarker $constructor_marker) {
        this(type, body);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0087\u0002\u00a2\u0006\u0002\b\nJ \u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u0087\u0002\u00a2\u0006\u0002\b\nJ\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0087\u0002\u00a2\u0006\u0002\b\nJ\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0087\u0002\u00a2\u0006\u0002\b\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnetwork/finschia/sdk/account/Address$Companion;", "", "()V", "ADDRESS_SIZE_IN_BYTE", "", "EMPTY_ADDRESS", "Lnetwork/finschia/sdk/account/Address;", "invoke", "body", "", "of", "bech32Address", "", "hrpPrefix", "pubKey", "Lnetwork/finschia/sdk/account/PubKey;", "type", "Lnetwork/finschia/sdk/account/Type;", "crypto"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmName(name="of")
        @NotNull
        public final Address of(@NotNull Type type, @NotNull byte[] body) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            boolean bl = body.length == 20;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Illegal body size(required 20, given " + body.length + ')';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return new Address(type, body, null);
        }

        @JvmStatic
        @JvmName(name="of")
        @NotNull
        public final Address of(@NotNull byte[] body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            return this.of(Type.ACCOUNT, body);
        }

        @JvmStatic
        @JvmOverloads
        @JvmName(name="of")
        @NotNull
        public final Address of(@NotNull String bech32Address, @NotNull String hrpPrefix) {
            Intrinsics.checkNotNullParameter((Object)bech32Address, (String)"bech32Address");
            Intrinsics.checkNotNullParameter((Object)hrpPrefix, (String)"hrpPrefix");
            Bech32.Bech32Data bech32Data = Bech32.decode((String)bech32Address);
            String string = bech32Data.hrp;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bech32Data.hrp");
            boolean bl = StringsKt.startsWith$default((String)string, (String)hrpPrefix, (boolean)false, (int)2, null);
            boolean bl2 = false;
            int n = 0;
            if (!bl) {
                boolean bl3 = false;
                String string2 = "Illegal HRP prefix('" + bech32Data.hrp + "' does not start with '" + hrpPrefix + "')";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            String string3 = bech32Data.hrp;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"bech32Data.hrp");
            n = hrpPrefix.length();
            boolean bl4 = false;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            Type type = Type.Companion.invoke(string4);
            byte[] body = Bech32Utils.convertBits(bech32Data.data, 0, bech32Data.data.length, 5, 8, true);
            Intrinsics.checkNotNullExpressionValue((Object)body, (String)"body");
            return this.of(type, body);
        }

        public static /* synthetic */ Address of$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "link";
            }
            return companion.of(string, string2);
        }

        @JvmStatic
        @JvmName(name="of")
        @NotNull
        public final Address of(@NotNull PubKey pubKey) {
            Intrinsics.checkNotNullParameter((Object)pubKey, (String)"pubKey");
            byte[] body = new RIPEMD160.Digest().digest(new SHA256.Digest().digest(pubKey.getBody()));
            Type type = pubKey.getType();
            Intrinsics.checkNotNullExpressionValue((Object)body, (String)"body");
            return this.of(type, body);
        }

        @JvmStatic
        @JvmOverloads
        @JvmName(name="of")
        @NotNull
        public final Address of(@NotNull String bech32Address) {
            Intrinsics.checkNotNullParameter((Object)bech32Address, (String)"bech32Address");
            return network.finschia.sdk.account.Address$Companion.of$default(this, bech32Address, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

