/*
 * Decompiled with CFR 0.152.
 */
package network.finschia.sdk.crypto;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import network.finschia.sdk.crypto.SecureRandomUtils;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;

public final class LinkKeys {
    public static final int PRIVATE_KEY_SIZE = 32;
    public static final double MIN_BOUNCY_CASTLE_VERSION = 1.46;

    private LinkKeys() {
    }

    public static byte[] createPrivateKey() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
        ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec("secp256k1");
        keyPairGenerator.initialize(ecGenParameterSpec, SecureRandomUtils.secureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        BigInteger d = ((ECPrivateKey)keyPair.getPrivate()).getD();
        return BigIntegers.asUnsignedByteArray((int)32, (BigInteger)d);
    }

    public static byte[] getPublicKey(byte[] privateKey, boolean compressed) {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        ECPoint pointQ = spec.getG().multiply(new BigInteger(1, privateKey));
        return pointQ.getEncoded(compressed);
    }

    static {
        Provider provider = Security.getProvider("BC");
        BouncyCastleProvider newProvider = new BouncyCastleProvider();
        if (newProvider.getVersion() < 1.46) {
            String message = String.format("The version of BouncyCastle should be %f or newer", 1.46);
            throw new RuntimeCryptoException(message);
        }
        if (provider != null) {
            Security.removeProvider("BC");
        }
        Security.addProvider((Provider)newProvider);
    }
}

