/*
 * Decompiled with CFR 0.152.
 */
package network.finschia.sdk.crypto;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import network.finschia.sdk.crypto.LinkKeys;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;
import org.bouncycastle.util.BigIntegers;
import org.jetbrains.annotations.Nullable;

public class ECDSASignature {
    private static final X9ECParameters curveParams = CustomNamedCurves.getByName((String)"secp256k1");
    static final ECDomainParameters curve = new ECDomainParameters(curveParams.getCurve(), curveParams.getG(), curveParams.getN(), curveParams.getH());
    private final byte[] privateKey;

    public ECDSASignature(byte[] privateKey) {
        this.privateKey = privateKey;
    }

    public byte[] recoverableSerialize(BigInteger[] sig, byte[] message) {
        byte recId = this.findRecoveryId(sig, message);
        ByteBuffer buffer = ByteBuffer.allocate(65);
        buffer.put(BigIntegers.asUnsignedByteArray((int)32, (BigInteger)sig[0]));
        buffer.put(BigIntegers.asUnsignedByteArray((int)32, (BigInteger)sig[1]));
        buffer.put(recId);
        return buffer.array();
    }

    public BigInteger[] generateSignature(byte[] message) {
        BigInteger p = new BigInteger(1, this.privateKey);
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPrivateKeyParameters param = new ECPrivateKeyParameters(p, curve);
        signer.init(true, (CipherParameters)param);
        BigInteger[] sig = signer.generateSignature(message);
        BigInteger r = sig[0];
        BigInteger s = sig[1];
        if (s.compareTo(curveParams.getN().shiftRight(1)) > 0) {
            s = curve.getN().subtract(s);
        }
        return new BigInteger[]{r, s};
    }

    public byte findRecoveryId(BigInteger[] sig, byte[] message) {
        byte[] publicKey = LinkKeys.getPublicKey(this.privateKey, false);
        BigInteger p = new BigInteger(1, publicKey);
        int recId = -1;
        for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
            BigInteger k = ECDSASignature.recoverFromSignature(i, sig, message);
            if (!p.equals(k)) continue;
            recId = i;
            break;
        }
        if (recId == -1) {
            throw new RuntimeException("Could not construct a recoverable key. This should never happen.");
        }
        return (byte)recId;
    }

    @Nullable
    private static BigInteger recoverFromSignature(int recId, BigInteger[] sig, byte[] message) {
        BigInteger r = sig[0];
        BigInteger s = sig[1];
        ECDSASignature.checkArgument(recId >= 0, "recId must be positive");
        ECDSASignature.checkArgument(r.signum() >= 0, "r must be positive");
        ECDSASignature.checkArgument(s.signum() >= 0, "s must be positive");
        ECDSASignature.checkArgument(message != null, "message cannot be null");
        BigInteger n = curve.getN();
        BigInteger i = BigInteger.valueOf((long)recId / 2L);
        BigInteger x = r.add(i.multiply(n));
        BigInteger prime = SecP256K1Curve.q;
        if (x.compareTo(prime) >= 0) {
            return null;
        }
        ECPoint ecPoint = ECDSASignature.decompressKey(x, (recId & 1) == 1);
        if (!ecPoint.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger e = new BigInteger(1, message);
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInv = r.modInverse(n);
        BigInteger srInv = rInv.multiply(s).mod(n);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
        ECPoint q = ECAlgorithms.sumOfTwoMultiplies((ECPoint)curve.getG(), (BigInteger)eInvrInv, (ECPoint)ecPoint, (BigInteger)srInv);
        return new BigInteger(1, q.getEncoded(false));
    }

    private static ECPoint decompressKey(BigInteger xBN, boolean yBit) {
        X9IntegerConverter x9 = new X9IntegerConverter();
        byte[] compEnc = x9.integerToBytes(xBN, 1 + x9.getByteLength(curve.getCurve()));
        compEnc[0] = (byte)(yBit ? 3 : 2);
        return curve.getCurve().decodePoint(compEnc);
    }

    private static void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static BigInteger publicKeyFromPrivate(BigInteger privKey) {
        ECPoint point = ECDSASignature.publicPointFromPrivate(privKey);
        byte[] encoded = point.getEncoded(false);
        return new BigInteger(1, Arrays.copyOfRange(encoded, 1, encoded.length));
    }

    public static ECPoint publicPointFromPrivate(BigInteger privKey) {
        if (privKey.bitLength() > curve.getN().bitLength()) {
            privKey = privKey.mod(curve.getN());
        }
        return new FixedPointCombMultiplier().multiply(curve.getG(), privKey);
    }

    public static BigInteger publicFromPoint(byte[] bits) {
        return new BigInteger(1, Arrays.copyOfRange(bits, 1, bits.length));
    }
}

