/*
 * Decompiled with CFR 0.152.
 */
package network.finschia.sdk.crypto;

import java.math.BigInteger;
import network.finschia.sdk.crypto.SecureRandomUtils;
import org.bouncycastle.util.BigIntegers;
import org.web3j.crypto.Bip32ECKeyPair;
import org.web3j.crypto.MnemonicUtils;

public final class Bip44WalletUtils {
    private Bip44WalletUtils() {
    }

    public static String generateMnemonic() {
        byte[] initialEntropy = new byte[16];
        SecureRandomUtils.secureRandom().nextBytes(initialEntropy);
        return MnemonicUtils.generateMnemonic((byte[])initialEntropy);
    }

    public static byte[] generatePrivateKey(String mnemonic, int accountNumber, int index) {
        byte[] seed = MnemonicUtils.generateSeed((String)mnemonic, null);
        Bip32ECKeyPair masterKeypair = Bip32ECKeyPair.generateKeyPair((byte[])seed);
        Bip32ECKeyPair bip44Keypair = Bip44WalletUtils.generateBip44KeyPair(masterKeypair, accountNumber, index);
        return BigIntegers.asUnsignedByteArray((int)32, (BigInteger)bip44Keypair.getPrivateKey());
    }

    static Bip32ECKeyPair generateBip44KeyPair(Bip32ECKeyPair master, int accountNumber, int index) {
        int LINK_COIN_TYPE = 438;
        int[] path = new int[]{-2147483604, -2147483210, accountNumber | Integer.MIN_VALUE, 0, index};
        return Bip32ECKeyPair.deriveKeyPair((Bip32ECKeyPair)master, (int[])path);
    }
}

