/*
 * Decompiled with CFR 0.152.
 */
package network.finschia.sdk.crypto;

import java.io.ByteArrayOutputStream;

public final class Bech32Utils {
    public static byte[] convertBits(byte[] in, int inStart, int inLen, int fromBits, int toBits, boolean pad) {
        int acc = 0;
        int bits = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream(64);
        int maxv = (1 << toBits) - 1;
        int max_acc = (1 << fromBits + toBits - 1) - 1;
        for (int i = 0; i < inLen; ++i) {
            int value = in[i + inStart] & 0xFF;
            acc = (acc << fromBits | value) & max_acc;
            bits += fromBits;
            while (bits >= toBits) {
                out.write(acc >>> (bits -= toBits) & maxv);
            }
        }
        if (pad) {
            if (bits > 0) {
                out.write(acc << toBits - bits & maxv);
            }
        } else if (bits >= fromBits || (acc << toBits - bits & maxv) != 0) {
            throw new IllegalArgumentException("Could not convert bits, invalid padding");
        }
        return out.toByteArray();
    }

    private Bech32Utils() {
    }
}

