package network.chaintech.sdpcomposemultiplatform

import androidx.compose.runtime.Composable
import androidx.compose.ui.ExperimentalComposeUiApi
import androidx.compose.ui.platform.LocalDensity
import androidx.compose.ui.platform.LocalWindowInfo

@OptIn(ExperimentalComposeUiApi::class)
@Composable
actual fun getScreenWidth(): Float {
    val density = LocalDensity.current
    val screenSize = LocalWindowInfo.current.containerSize
    val width = with(density) { screenSize.width.toDp() }
    return width.value
}

@OptIn(ExperimentalComposeUiApi::class)
@Composable
actual fun getScreenHeight(): Float {
    val density = LocalDensity.current
    val screenSize = LocalWindowInfo.current.containerSize
    val height = with(density) { screenSize.height.toDp() }
    return height.value
}