package network.chaintech.sdpcomposemultiplatform

import androidx.compose.runtime.Composable
import androidx.compose.ui.platform.LocalDensity
import androidx.compose.ui.unit.Density
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.TextUnit
import androidx.compose.ui.unit.dp

val Int.sdp: Dp
    @Composable
    get() = this.sdpGet()

val Int.ssp: TextUnit
    @Composable get() = this.sspGet()


@Composable
private fun Int.sdpGet(): Dp {
    val ratio = screenWidth() / 300.0
    return (this * ratio).dp
}

@Composable
private fun Int.sspGet(): TextUnit {
    return this.textSdp(density = LocalDensity.current)
}

@Composable
private fun Int.textSdp(density: Density): TextUnit = with(density) {
    this@textSdp.sdp.toSp()
}

@Composable
expect fun screenWidth(): Float