package qrscanner

import kmpImagePicker.utils.SharedImage
import kotlinx.cinterop.ExperimentalForeignApi
import platform.CoreImage.CIDetector
import platform.CoreImage.CIDetectorAccuracy
import platform.CoreImage.CIDetectorAccuracyHigh
import platform.CoreImage.CIDetectorTypeQRCode
import platform.CoreImage.CIImage
import platform.CoreImage.CIQRCodeFeature

@OptIn(ExperimentalForeignApi::class)
actual fun scanImage(image: SharedImage?, onCompletion: (String) -> Unit, onFailure: (String) -> Unit) {
    val detector = CIDetector.detectorOfType(
        CIDetectorTypeQRCode,
        context = null,
        options = mapOf(CIDetectorAccuracy to CIDetectorAccuracyHigh)
    )
    val ciImage = CIImage(image?.toUIImage()?.CGImage())
    var qrCodeValue = ""
    val features = detector?.featuresInImage(ciImage)

    val qrCodeFeatures: List<CIQRCodeFeature> = if (features is List<*>) {
        features.filterIsInstance<CIQRCodeFeature>()
    } else {
        emptyList()
    }

    for (feature in qrCodeFeatures) {
        qrCodeValue += feature.messageString ?: ""
    }

    if (qrCodeValue.isNotEmpty()) {
        onCompletion(qrCodeValue)
    } else {
        onFailure("")
    }
}