package network.chaintech.ui.datetimepicker

import androidx.compose.animation.animateContentSize
import androidx.compose.foundation.clickable
import androidx.compose.foundation.interaction.MutableInteractionSource
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.LocalContentColor
import androidx.compose.material3.LocalTextStyle
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.composed
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.Shape
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import androidx.compose.ui.window.Dialog
import androidx.compose.ui.window.DialogProperties
import kotlinx.datetime.LocalDateTime
import network.chaintech.utils.MAX
import network.chaintech.utils.MIN
import network.chaintech.utils.SelectorProperties
import network.chaintech.utils.TimeFormat
import network.chaintech.utils.WheelPickerDefaults
import network.chaintech.utils.now


@Composable
fun WheelDateTimePickerDialog(
    modifier: Modifier = Modifier,
    showDatePicker: Boolean = false,
    title: String = "DATE & TIME PICKER",
    doneLabel: String = "Done",
    timeFormat: TimeFormat = TimeFormat.HOUR_24,
    titleStyle: TextStyle = LocalTextStyle.current,
    doneLabelStyle: TextStyle = LocalTextStyle.current,
    startDate: LocalDateTime = LocalDateTime.now(),
    minDate: LocalDateTime = LocalDateTime.MIN(),
    maxDate: LocalDateTime = LocalDateTime.MAX(),
    yearsRange: IntRange? = IntRange(1922, 2122),
    height: Dp,
    rowCount: Int = 3,
    dateTextStyle: TextStyle = MaterialTheme.typography.titleMedium,
    dateTextColor: Color = LocalContentColor.current,
    hideHeader: Boolean = false,
    containerColor: Color = Color.White,
    shape: Shape = RoundedCornerShape(10.dp),
    selectorProperties: SelectorProperties = WheelPickerDefaults.selectorProperties(),
    onDoneClick: (snappedDate: LocalDateTime) -> Unit = {},
    onDateChangeListener: (snappedDate: LocalDateTime) -> Unit = {},
    onDismiss: () -> Unit = {},
) {
    if (showDatePicker) {
        Dialog(
            onDismissRequest = { onDismiss() },
            properties = DialogProperties(
                usePlatformDefaultWidth = false
            ),
        ) {
            Box(
                contentAlignment = Alignment.Center,
                modifier = Modifier
                    .fillMaxSize()
                    .noRippleEffect {
                        onDismiss()
                    }
            ) {
                Surface(
                    modifier = Modifier
                        .padding(horizontal = 16.dp)
                        .fillMaxWidth()
                        .animateContentSize(),
                    shape = shape,
                    color = containerColor,
                ) {
                    WheelDateTimePickerComponent.WheelDateTimePicker(
                        modifier = modifier,
                        title = title,
                        timeFormat = timeFormat,
                        doneLabel = doneLabel,
                        titleStyle = titleStyle,
                        doneLabelStyle = doneLabelStyle,
                        startDateTime = startDate,
                        minDateTime = minDate,
                        maxDateTime = maxDate,
                        yearsRange = yearsRange,
                        height = height,
                        rowCount = rowCount,
                        dateTextStyle = dateTextStyle,
                        dateTextColor = dateTextColor,
                        hideHeader = hideHeader,
                        selectorProperties = selectorProperties,
                        onDoneClick = {
                            onDoneClick(it)
                        },
                        onDateChangeListener = onDateChangeListener
                    )
                }
            }
        }
    }
}

fun Modifier.noRippleEffect(
    onClick: () -> Unit
) = composed {
    this.clickable(
        interactionSource = remember { MutableInteractionSource() },
        indication = null,
        onClick = onClick
    )
}