package network.chaintech.ui.datetimepicker

import androidx.compose.material3.BottomSheetDefaults
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.LocalContentColor
import androidx.compose.material3.LocalTextStyle
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.ModalBottomSheet
import androidx.compose.material3.rememberModalBottomSheetState
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.Shape
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.unit.Dp
import kotlinx.datetime.LocalDateTime
import network.chaintech.utils.MAX
import network.chaintech.utils.MIN
import network.chaintech.utils.SelectorProperties
import network.chaintech.utils.TimeFormat
import network.chaintech.utils.WheelPickerDefaults
import network.chaintech.utils.now


@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun WheelDateTimePickerBottomSheet(
    modifier: Modifier = Modifier,
    showDatePicker: Boolean = false,
    title: String = "DATE & TIME PICKER",
    doneLabel: String = "Done",
    timeFormat: TimeFormat = TimeFormat.HOUR_24,
    titleStyle: TextStyle = LocalTextStyle.current,
    doneLabelStyle: TextStyle = LocalTextStyle.current,
    startDate: LocalDateTime = LocalDateTime.now(),
    minDate: LocalDateTime = LocalDateTime.MIN(),
    maxDate: LocalDateTime = LocalDateTime.MAX(),
    yearsRange: IntRange? = IntRange(1922, 2122),
    height: Dp,
    rowCount: Int = 3,
    dateTextStyle: TextStyle = MaterialTheme.typography.titleMedium,
    dateTextColor: Color = LocalContentColor.current,
    hideHeader: Boolean = false,
    containerColor: Color = Color.White,
    shape: Shape = BottomSheetDefaults.ExpandedShape,
    dragHandle: @Composable (() -> Unit)? = { BottomSheetDefaults.DragHandle() },
    selectorProperties: SelectorProperties = WheelPickerDefaults.selectorProperties(),
    onDoneClick: (snappedDate: LocalDateTime) -> Unit = {},
    onDateChangeListener: (snappedDate: LocalDateTime) -> Unit = {},
    onDismiss: () -> Unit = {},
) {
    if (showDatePicker) {
        val modalBottomSheetState = rememberModalBottomSheetState()

        ModalBottomSheet(
            onDismissRequest = { onDismiss() },
            sheetState = modalBottomSheetState,
            dragHandle = dragHandle,
            shape = shape,
            containerColor = containerColor,
        ) {
            WheelDateTimePickerComponent.WheelDateTimePicker(
                modifier = modifier,
                title = title,
                timeFormat = timeFormat,
                doneLabel = doneLabel,
                titleStyle = titleStyle,
                doneLabelStyle = doneLabelStyle,
                startDateTime = startDate,
                minDateTime = minDate,
                maxDateTime = maxDate,
                yearsRange = yearsRange,
                height = height,
                rowCount = rowCount,
                dateTextStyle = dateTextStyle,
                dateTextColor = dateTextColor,
                hideHeader = hideHeader,
                selectorProperties = selectorProperties,
                onDoneClick = {
                    onDoneClick(it)
                },
                onDateChangeListener = onDateChangeListener
            )
        }
    }
}