package network.chaintech.ui.timepicker

import androidx.compose.animation.animateContentSize
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.LocalContentColor
import androidx.compose.material3.LocalTextStyle
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.Shape
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import androidx.compose.ui.window.Dialog
import kotlinx.datetime.LocalTime
import network.chaintech.utils.MAX
import network.chaintech.utils.MIN
import network.chaintech.utils.now


@Composable
fun WheelTimePickerDialog(
    modifier: Modifier = Modifier,
    showTimePicker: Boolean = false,
    title: String = "TIME PICKER",
    doneLabel: String = "Done",
    titleStyle: TextStyle = LocalTextStyle.current,
    doneLabelStyle: TextStyle = LocalTextStyle.current,
    startTime: LocalTime = LocalTime.now(),
    minTime: LocalTime = LocalTime.MIN(),
    maxTime: LocalTime = LocalTime.MAX(),
    timeFormat: TimeFormat = TimeFormat.HOUR_24,
    height: Dp,
    rowCount: Int = 3,
    textStyle: TextStyle = MaterialTheme.typography.titleMedium,
    textColor: Color = LocalContentColor.current,
    hideHeader: Boolean = false,
    containerColor: Color = Color.White,
    shape: Shape = RoundedCornerShape(10.dp),
    selectorProperties: SelectorProperties = WheelPickerDefaults.selectorProperties(),
    onDoneClick: (snappedDate: LocalTime) -> Unit = {},
    onTimeChangeListener: (snappedDate: LocalTime) -> Unit = {},
    onDismiss: () -> Unit = {},
) {
    if (showTimePicker) {
        Dialog(onDismissRequest = { onDismiss() }) {
            Box(
                contentAlignment = Alignment.Center,
                modifier = Modifier
                    .fillMaxSize()
                    .noRippleEffect {
                        onDismiss()
                    }
            ) {
                Surface(
                    modifier = Modifier
                        .padding(horizontal = 16.dp)
                        .fillMaxWidth()
                        .animateContentSize(),
                    shape = shape,
                    color = containerColor,
                ) {
                    WheelTimePickerComponent.WheelTimePicker(
                        modifier = modifier,
                        title = title,
                        doneLabel = doneLabel,
                        titleStyle = titleStyle,
                        doneLabelStyle = doneLabelStyle,
                        textColor = textColor,
                        timeFormat = timeFormat,
                        selectorProperties = selectorProperties,
                        rowCount = rowCount,
                        height = height,
                        hideHeader = hideHeader,
                        startTime = startTime,
                        minTime = minTime,
                        maxTime = maxTime,
                        textStyle = textStyle,
                        onDoneClick = {
                            onDoneClick(it)
                        },
                        onTimeChangeListener = onTimeChangeListener,
                    )
                }
            }
        }
    }
}