package network.chaintech.ui.timepicker

import androidx.compose.foundation.clickable
import androidx.compose.foundation.interaction.MutableInteractionSource
import androidx.compose.material3.BottomSheetDefaults
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.LocalContentColor
import androidx.compose.material3.LocalTextStyle
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.ModalBottomSheet
import androidx.compose.material3.rememberModalBottomSheetState
import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.composed
import androidx.compose.ui.draw.drawWithContent
import androidx.compose.ui.graphics.BlendMode
import androidx.compose.ui.graphics.Brush
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.CompositingStrategy
import androidx.compose.ui.graphics.Shape
import androidx.compose.ui.graphics.graphicsLayer
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.unit.Dp
import kotlinx.datetime.LocalTime
import network.chaintech.utils.MAX
import network.chaintech.utils.MIN
import network.chaintech.utils.now

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun WheelTimePickerBottomSheet(
    modifier: Modifier = Modifier,
    showTimePicker: Boolean = false,
    title: String = "TIME PICKER",
    doneLabel: String = "Done",
    titleStyle: TextStyle = LocalTextStyle.current,
    doneLabelStyle: TextStyle = LocalTextStyle.current,
    startTime: LocalTime = LocalTime.now(),
    minTime: LocalTime = LocalTime.MIN(),
    maxTime: LocalTime = LocalTime.MAX(),
    timeFormat: TimeFormat = TimeFormat.HOUR_24,
    height: Dp,
    rowCount: Int = 3,
    textStyle: TextStyle = MaterialTheme.typography.titleMedium,
    textColor: Color = LocalContentColor.current,
    hideHeader: Boolean = false,
    containerColor: Color = Color.White,
    shape: Shape = BottomSheetDefaults.ExpandedShape,
    dragHandle: @Composable (() -> Unit)? = { BottomSheetDefaults.DragHandle() },
    selectorProperties: SelectorProperties = WheelPickerDefaults.selectorProperties(),
    onDoneClick: (snappedDate: LocalTime) -> Unit = {},
    onTimeChangeListener: (snappedDate: LocalTime) -> Unit = {},
    onDismiss: () -> Unit = {},
) {
    val modalBottomSheetState = rememberModalBottomSheetState()

    if (showTimePicker) {
        ModalBottomSheet(
            onDismissRequest = { onDismiss() },
            sheetState = modalBottomSheetState,
            dragHandle = dragHandle,
            shape = shape,
            containerColor = containerColor,
        ) {
            WheelTimePickerComponent.WheelTimePicker(
                modifier = modifier,
                title = title,
                doneLabel = doneLabel,
                titleStyle = titleStyle,
                doneLabelStyle = doneLabelStyle,
                textColor = textColor,
                timeFormat = timeFormat,
                selectorProperties = selectorProperties,
                rowCount = rowCount,
                height = height,
                hideHeader = hideHeader,
                startTime = startTime,
                minTime = minTime,
                maxTime = maxTime,
                textStyle = textStyle,
                onDoneClick = {
                    onDoneClick(it)
                },
                onTimeChangeListener = onTimeChangeListener,
            )
        }
    }
}


fun Modifier.noRippleEffect(
    onClick: () -> Unit
) = composed {
    this.clickable(
        interactionSource = remember { MutableInteractionSource() },
        indication = null,
        onClick = onClick
    )
}


fun Modifier.fadingEdge(brush: Brush) = this
    .graphicsLayer(compositingStrategy = CompositingStrategy.Offscreen)
    .drawWithContent {
        drawContent()
        drawRect(brush = brush, blendMode = BlendMode.DstIn)
    }