package network.chaintech

import android.os.Build
import androidx.annotation.RequiresApi
import java.time.format.DateTimeFormatter
import java.util.Locale
import kotlinx.datetime.LocalDate
import kotlinx.datetime.LocalDateTime
import kotlinx.datetime.LocalTime
import kotlinx.datetime.toJavaLocalDate
import kotlinx.datetime.toJavaLocalDateTime
import kotlinx.datetime.toJavaLocalTime
import kotlinx.datetime.toKotlinLocalDateTime

@RequiresApi(Build.VERSION_CODES.O)
actual fun format(localDateTime: LocalDateTime, outputFormat: String): String {
    val str = DateTimeFormatter
        .ofPattern(outputFormat, Locale.getDefault())
        .format(localDateTime.toJavaLocalDateTime())
    return str
}

@RequiresApi(Build.VERSION_CODES.O)
actual fun parse(strDateTime: String, dateFormat: String): LocalDateTime {
    val formatter = DateTimeFormatter.ofPattern(dateFormat, Locale.getDefault())
    return java.time.LocalDateTime
        .parse(strDateTime, formatter)
        .toKotlinLocalDateTime()
}

@RequiresApi(Build.VERSION_CODES.O)
actual fun format(localTime: LocalTime, outputFormat: String): String {
    val str = DateTimeFormatter
        .ofPattern(outputFormat, Locale.getDefault())
        .format(localTime.toJavaLocalTime())
    return str
}


@RequiresApi(Build.VERSION_CODES.O)
actual fun format(localDate: LocalDate, outputFormat: String): String {
    val str = DateTimeFormatter
        .ofPattern(outputFormat, Locale.getDefault())
        .format(localDate.toJavaLocalDate())
    return str
}