package network.chaintech.composeMultiplatformScreenCapture.utility

import platform.UIKit.UIActivityViewController
import platform.UIKit.UIApplication
import platform.UIKit.UIImage
import platform.UIKit.UIWindow

fun shareScreenshot(image: UIImage) {
    val window = UIApplication.sharedApplication.windows.filter {
        (it as UIWindow).isKeyWindow()
    }.first() as UIWindow

    val currentViewController = window.rootViewController
    val activityViewController = UIActivityViewController(
        activityItems = listOf(image),
        applicationActivities = null
    )
    currentViewController?.presentViewController(
        viewControllerToPresent = activityViewController,
        animated = true,
        completion = null,
    )
}