package network.chaintech.composeMultiplatformScreenCapture

import androidx.compose.runtime.Composable
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember

class ScreenCaptureController {
    var isCaptureScreen = mutableStateOf(false)
        private set

    fun capture() {
        isCaptureScreen.value = true
    }

    internal fun captured() {
        isCaptureScreen.value = false
    }
}

@Composable
fun rememberScreenCaptureController(): ScreenCaptureController {
    return remember { ScreenCaptureController() }
}