package network.chaintech.composeMultiplatformScreenCapture

import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.verticalScroll
import androidx.compose.runtime.Composable
import androidx.compose.runtime.DisposableEffect
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.ImageBitmap
import androidx.compose.ui.layout.onGloballyPositioned
import androidx.compose.ui.platform.LocalDensity
import network.chaintech.composeMultiplatformScreenCapture.extension.toPixel
import network.chaintech.composeMultiplatformScreenCapture.model.SizeModel

@Composable
actual fun ScreenCaptureComposable(
    modifier: Modifier,
    screenCaptureController: ScreenCaptureController,
    shareImage: Boolean,
    onCaptured: (ImageBitmap?, Throwable?) -> Unit,
    content: @Composable () -> Unit
) {
    val density = LocalDensity.current

    TakeScreenShot(screenCaptureController, shareImage, onCaptured, content)

    Box(
        modifier = Modifier
            .verticalScroll(rememberScrollState())
            .onGloballyPositioned { coordinates ->
                val height = with(density) { coordinates.size.height.toDp() }
                val width1 = with(density) { coordinates.size.width.toDp() }
                screenShotSize = SizeModel(
                    width = width1.toPixel().toDouble(),
                    height = height.toPixel().toDouble()
                )
            }
    ) {
        content()
    }

    DisposableEffect(Unit) {
        onDispose { screenShotSize = null }
    }
}

actual object AppContext