package network.chaintech.composeMultiplatformScreenCapture

import android.graphics.Bitmap
import android.graphics.Canvas
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.wrapContentHeight
import androidx.compose.runtime.Composable
import androidx.compose.runtime.DisposableEffect
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.ComposeView
import androidx.compose.ui.viewinterop.AndroidView
import androidx.core.widget.NestedScrollView
import network.chaintech.composeMultiplatformScreenCapture.utility.share


@Composable
fun ScrollableScreenCapture(
    modifier: Modifier = Modifier,
    screenCaptureController: ScreenCaptureController,
    shareImage: Boolean,
    onCapturedScreen: (Bitmap?, Throwable?) -> Unit,
    content: @Composable () -> Unit
) {
    Box(modifier) {
        AndroidView(factory = { context ->
            val scrollView = NestedScrollView(context)
            val composeView = ComposeView(context).apply {
                setContent {
                    content()
                }
            }
            scrollView.addView(composeView)
            scrollView
        }, update = { scrollView ->
            if (screenCaptureController.isCaptureScreen.value) {
                scrollView.isVerticalScrollBarEnabled = false
                scrollView.isHorizontalScrollBarEnabled = false
                try {
                    loadBitmapFromScrollView(scrollView) {
                        onCapturedScreen(it, null)
                        if (shareImage)
                            share(it)
                    }
                } catch (throwable: Throwable) {
                    throwable.printStackTrace()
                    onCapturedScreen(null, throwable)
                }
                scrollView.isVerticalScrollBarEnabled = true
                scrollView.isHorizontalScrollBarEnabled = true
                screenCaptureController.captured()
            }
        }, modifier = Modifier
            .fillMaxWidth()
            .wrapContentHeight()
        )
    }

    DisposableEffect(Unit) {
        onDispose {}
    }
}

private fun loadBitmapFromScrollView(
    scrollView: NestedScrollView, bitmapCallback: (Bitmap) -> Unit
) {
    val tBitmap = Bitmap.createBitmap(
        scrollView.width, scrollView.getChildAt(0).height, Bitmap.Config.ARGB_8888
    )
    val canvas = Canvas(tBitmap)
    scrollView.draw(canvas)
    canvas.setBitmap(null)
    bitmapCallback.invoke(tBitmap)
}