package network.chaintech.composeMultiplatformScreenCapture.utility

import android.content.ClipData
import android.content.Intent
import android.graphics.Bitmap
import androidx.compose.ui.graphics.ImageBitmap
import androidx.compose.ui.graphics.asAndroidBitmap
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import network.chaintech.composeMultiplatformScreenCapture.helper.getUri

fun share(imageBitmap: ImageBitmap) {
    CoroutineScope(Dispatchers.Main).launch {
        val context = network.chaintech.composeMultiplatformScreenCapture.AppContext.get()
        val intentShareFile = Intent(Intent.ACTION_SEND)
        val mimeType = "image/*"
        val mimeTypeArray = arrayOf(mimeType)
        intentShareFile.setType(mimeType)
        val uri = imageBitmap.asAndroidBitmap().getUri(context)
        intentShareFile.clipData = ClipData(
            "A label describing your file to the user",
            mimeTypeArray,
            ClipData.Item(uri)
        )
        intentShareFile.putExtra(Intent.EXTRA_STREAM, uri)
        intentShareFile.setFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION or Intent.FLAG_GRANT_READ_URI_PERMISSION)
        context.startActivity(intentShareFile)
    }
}

fun share(bitmap: Bitmap) {
    CoroutineScope(Dispatchers.Main).launch {
        val context = network.chaintech.composeMultiplatformScreenCapture.AppContext.get()
        val intentShareFile = Intent(Intent.ACTION_SEND)
        val mimeType = "image/*"
        val mimeTypeArray = arrayOf(mimeType)
        intentShareFile.setType(mimeType)
        val uri = bitmap.getUri(context)
        intentShareFile.clipData = ClipData(
            "A label describing your file to the user",
            mimeTypeArray,
            ClipData.Item(uri)
        )
        intentShareFile.putExtra(Intent.EXTRA_STREAM, uri)
        intentShareFile.setFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION or Intent.FLAG_GRANT_READ_URI_PERMISSION)
        context.startActivity(intentShareFile)
    }
}