package network.chaintech.composeMultiplatformScreenshot

import android.content.Context
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.statusBarsPadding
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.ImageBitmap
import androidx.compose.ui.graphics.asImageBitmap
import java.lang.ref.WeakReference

@Composable
actual fun ScreenCaptureComposable(
    modifier: Modifier,
    screenCaptureController: ScreenCaptureController,
    shareImage: Boolean,
    onCaptured: (ImageBitmap?, Throwable?) -> Unit,
    content: @Composable () -> Unit
) {
    ScrollableScreenCapture(
        screenCaptureController = screenCaptureController,
        onCapturedScreen = { bitmap, error ->
            onCaptured(bitmap?.asImageBitmap(), error)
        },
        shareImage = shareImage,
        modifier = modifier
            .statusBarsPadding()
            .fillMaxWidth(),
    ) {
        content()
    }
}

actual object AppContext {
    private var value: WeakReference<Context?>? = null
    fun set(context: Context) {
        value = WeakReference(context)
    }

    internal fun get(): Context {
        return value?.get() ?: throw RuntimeException("Context Error")
    }
}



