package chaintech.videoplayer.model

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import org.jetbrains.compose.resources.DrawableResource
import org.jetbrains.compose.resources.ExperimentalResourceApi

data class PlayerConfig @OptIn(ExperimentalResourceApi::class) constructor(
    var enablePauseResume: Boolean = true,
    var showSeekBar: Boolean = true,
    var showDuration: Boolean = true,
    var thumbColor: Color = Color.Red,
    var activeTrackColor: Color = Color.White,
    var inactiveTrackColor: Color = Color.Black.copy(alpha = 0.4f),
    var textColor: Color = Color.White,
    var seekBarBottomPadding: Dp = 10.dp,
    var playIcon: DrawableResource? = null,
    var pauseIcon: DrawableResource? = null,
    var pauseResumeIconSize: Dp = 40.dp,
    var reelVerticalScrolling: Boolean = true,
    var autoHideControl:Boolean = true,
    var controlHideInterval: Int = 3,  //Seconds
    var enableFastForwardBackward: Boolean = true,
    var fastForwardIcon: DrawableResource? = null,
    var fastBackwardIcon: DrawableResource? = null,
    var fastForwardBackwardInterval: Int = 10  //Seconds
)