package chaintech.videoplayer.util

import platform.Foundation.NSString
import platform.Foundation.stringWithFormat

actual fun formatMinSec(value: Int): String {
    val hour = (value / 3600)
    val remainingSecondsAfterHours = (value % 3600)
    val minutes = remainingSecondsAfterHours / 60
    val seconds = remainingSecondsAfterHours % 60

    val strHour : String = if (hour > 0) { NSString.stringWithFormat(format = "%02d:", hour)
    } else { "" }
    val strMinutes : String = NSString.stringWithFormat(format = "%02d:", minutes)
    val strSeconds : String = NSString.stringWithFormat(format = "%02d", seconds)

    return "${strHour}${strMinutes}${strSeconds}"
}