package chaintech.videoplayer.ui

import androidx.compose.animation.AnimatedVisibility
import androidx.compose.animation.fadeIn
import androidx.compose.animation.fadeOut
import androidx.compose.foundation.Image
import androidx.compose.foundation.gestures.detectTapGestures
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.size
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Pause
import androidx.compose.material.icons.filled.PlayArrow
import androidx.compose.material3.Icon
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.input.pointer.pointerInput
import androidx.compose.ui.layout.ContentScale
import chaintech.videoplayer.model.PlayerConfig
import org.jetbrains.compose.resources.ExperimentalResourceApi
import org.jetbrains.compose.resources.painterResource

@OptIn(ExperimentalResourceApi::class)
@Composable
fun PlayView(
    playerConfig: PlayerConfig,
    isPause: Boolean,
    onPauseToggle: (() -> Unit),
    showControls: Boolean
) {
        AnimatedVisibility(
            modifier = Modifier,
            visible = showControls,
            enter = fadeIn(),
            exit = fadeOut()
        ) {
            Box(
                modifier = Modifier
                    .fillMaxSize(),
                contentAlignment = Alignment.Center
            ) {
                Box(
                    modifier = Modifier
                        .size(playerConfig.pauseResumeIconSize)
                        .pointerInput(Unit) {
                            detectTapGestures { _ ->
                                onPauseToggle()
                            }
                        }
                ) {
                    if ((playerConfig.playIcon != null) && (playerConfig.pauseIcon != null)) {
                        Image(
                            painter = if (isPause) painterResource(playerConfig.playIcon!!) else painterResource(
                                playerConfig.pauseIcon!!
                            ),
                            contentDescription = "Play/Pause",
                            contentScale = ContentScale.Fit,
                            modifier = Modifier
                                .fillMaxSize()
                        )
                    } else {
                        Icon(
                            imageVector = if (isPause) Icons.Filled.PlayArrow else Icons.Filled.Pause,
                            contentDescription = "Play/Pause",
                            tint = Color.White,
                            modifier = Modifier
                                .fillMaxSize()
                        )
                    }
                }
            }
        }
}