package chaintech.videoplayer.ui

import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import chaintech.videoplayer.model.PlayerConfig
import kotlinx.coroutines.delay
import org.jetbrains.compose.resources.ExperimentalResourceApi

@OptIn(ExperimentalResourceApi::class)
@Composable
fun VideoPlayerView(modifier : Modifier = Modifier,
                    url: String,
                    playerConfig: PlayerConfig = PlayerConfig()
) {

    var isPause by remember { mutableStateOf(false) }
    var showControls by remember { mutableStateOf(true) }

    if(playerConfig.autoHideControl) {
        LaunchedEffect(showControls) {
            if (showControls) {
                delay(timeMillis = (playerConfig.controlHideInterval * 1000).toLong())
                showControls = false
            }
        }
    }
    VideoPlayerWithControl(
        modifier = modifier,
        url = url,
        playerConfig = playerConfig,
        isPause = isPause,
        onPauseToggle = {isPause = isPause.not()},
        showControls = showControls,
        onShowControlsToggle = {showControls = showControls.not()}
    )
}







