package chaintech.videoplayer.ui

import androidx.compose.foundation.gestures.detectTapGestures
import androidx.compose.foundation.layout.Box
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.input.pointer.pointerInput
import chaintech.videoplayer.model.PlayerConfig
import chaintech.videoplayer.util.CMPPlayer

@Composable
fun VideoPlayerWithoutControl(modifier : Modifier,
                              url: String,
                              playerConfig: PlayerConfig,
                              isPause: Boolean,
                              onPauseToggle: (() -> Unit),
                              showControls: Boolean,
                              onShowControlsToggle: (() -> Unit)) {
    Box(
        modifier = modifier
            .pointerInput(Unit) {
                detectTapGestures { _ ->
                    onShowControlsToggle()
                }
            }
    ) {
        CMPPlayer(
            modifier = modifier,
            url = url,
            isPause = isPause)

        if (playerConfig.enablePauseResume) {
            PlayView(
                playerConfig = playerConfig,
                isPause = isPause,
                onPauseToggle = onPauseToggle,
                showControls = showControls
            )
        }
    }
}
