package chaintech.videoplayer.ui

import androidx.compose.foundation.Image
import androidx.compose.foundation.gestures.detectTapGestures
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.size
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.PlayArrow
import androidx.compose.material3.Icon
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.input.pointer.pointerInput
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.unit.dp
import chaintech.videoplayer.util.CMPPlayer
import org.jetbrains.compose.resources.DrawableResource
import org.jetbrains.compose.resources.ExperimentalResourceApi
import org.jetbrains.compose.resources.painterResource

@OptIn(ExperimentalResourceApi::class)
@Composable
fun VideoPlayerWithoutControl(modifier : Modifier,
                                      url: String,
                                      enablePauseResume: Boolean,
                                      isPause: Boolean,
                                      onPauseToggle: (() -> Unit),
                                      playIcon: DrawableResource? = null,
                                      pauseIcon: DrawableResource? = null) {
    Box(
        modifier = modifier
            .pointerInput(Unit) {
                detectTapGestures { _ ->
                    if (enablePauseResume) {
                        onPauseToggle()
                    }
                }
            }
    ) {
        CMPPlayer(
            modifier = modifier,
            url = url,
            isPause = isPause)

        if (enablePauseResume && isPause) {
            ResumeIcon(playIcon)
        }
    }
}

@OptIn(ExperimentalResourceApi::class)
@Composable
private fun ResumeIcon(playIcon: DrawableResource?) {
    Box(
        modifier = Modifier
            .fillMaxSize(),
        contentAlignment = Alignment.Center
    ) {
        if (playIcon != null) {
            Image(
                painter = painterResource(playIcon),
                contentDescription = "Play/Pause",
                contentScale = ContentScale.Fit,
                modifier = Modifier
                    .size(50.dp)
            )
        } else {
            Icon(
                imageVector = Icons.Filled.PlayArrow,
                contentDescription = "Play/Pause",
                tint = Color.White,
                modifier = Modifier
                    .size(50.dp)
            )
        }
    }
}