package chaintech.videoplayer.ui

import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import org.jetbrains.compose.resources.DrawableResource
import org.jetbrains.compose.resources.ExperimentalResourceApi

@OptIn(ExperimentalResourceApi::class)
@Composable
fun VideoPlayerView(modifier : Modifier = Modifier,
                    url: String,
                    enablePauseResume: Boolean = true,
                    showSeekBar: Boolean = false,
                    showDuration: Boolean = true,
                    playIcon: DrawableResource? = null,
                    pauseIcon:DrawableResource? = null
) {

    var isPause by remember { mutableStateOf(false) }
    var showControls by remember { mutableStateOf(true) }

    if (showSeekBar) {
        VideoPlayerWithControl(
            modifier = modifier,
            url = url,
            enablePauseResume = enablePauseResume,
            isPause = isPause,
            onPauseToggle = {isPause = isPause.not()},
            showControls = showControls,
            onShowControlsToggle = {showControls = showControls.not()},
            showDuration = showDuration,
            playIcon = playIcon,
            pauseIcon = pauseIcon
        )
    } else {
        VideoPlayerWithoutControl(
            modifier = modifier,
            url = url,
            enablePauseResume = enablePauseResume,
            isPause = isPause,
            onPauseToggle = {isPause = isPause.not()},
            playIcon = playIcon,
            pauseIcon = pauseIcon
        )
    }
}







