package chaintech.videoplayer.util

import androidx.compose.foundation.layout.Box
import androidx.compose.runtime.Composable
import androidx.compose.runtime.DisposableEffect
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.ui.Modifier
import androidx.compose.ui.viewinterop.AndroidView

@Composable
actual fun CMPPlayer(
    modifier: Modifier,
    url: String,
    isPause: Boolean
) {
    val exoPlayer = rememberExoPlayerWithLifecycle(url)
    val playerView = rememberPlayerView(exoPlayer)

    LaunchedEffect(playerView) {
        playerView.keepScreenOn = true
    }


    Box {
        AndroidView(
            factory = { playerView },
            modifier = modifier,
            update = {
                exoPlayer.playWhenReady = !isPause
            }
        )
    }

    DisposableEffect(url) {
        onDispose {
            playerView.keepScreenOn = false
            exoPlayer.release()
        }
    }
}