package network.chaintech.cmpeasypermission

import androidx.compose.runtime.Composable
import network.chaintech.cmpeasypermission.DialogParams
import platform.Foundation.NSURL
import platform.UIKit.UIApplication
import platform.UIKit.UIApplicationOpenSettingsURLString

@Composable
actual fun RequestPermission(
    permission: PermissionState,
    openSetting: Boolean,
    deniedDialogParams: DialogParams?,
    isGranted: (Boolean) -> Unit,
) {
    when (permission) {
        PermissionState.CAMERA -> {
            handleCameraAuthorizationStatus(deniedDialogParams, isGranted, openSetting)
        }

        PermissionState.RECORD_AUDIO -> {
            handleMicroPhoneAuthorizationStatus(deniedDialogParams, isGranted, openSetting)
        }

        PermissionState.ACCESS_FINE_LOCATION, PermissionState.ACCESS_COARSE_LOCATION -> {
            LocationManager().handleLocationAuthorizationStatus(
                deniedDialogParams,
                isGranted,
                openSetting
            )
        }

        PermissionState.WRITE_CONTACTS, PermissionState.READ_CONTACTS -> {
            handleContactAuthorizationStatus(deniedDialogParams, isGranted, openSetting)
        }

        PermissionState.READ_CALENDAR, PermissionState.WRITE_CALENDAR -> {
            handleCalendarAuthorizationStatus(deniedDialogParams, isGranted, openSetting)
        }

        PermissionState.POST_NOTIFICATIONS -> {
            handleNotificationAuthorizationStatus(deniedDialogParams, isGranted, openSetting)
        }

        PermissionState.BLUETOOTH -> {
            BluetoothPermissionManager().handleBluetoothAuthorizationStatus(deniedDialogParams, isGranted, openSetting)
        }

        PermissionState.STORAGE -> {
            handleGalleryAuthorizationStatus(deniedDialogParams, isGranted, openSetting)
        }

        else -> {
            isGranted(true)
        }
    }
}


fun openAppSettings() {
    val settingsUrl = NSURL(string = UIApplicationOpenSettingsURLString)
    UIApplication.sharedApplication().openURL(settingsUrl)
}

actual enum class PermissionState(val value: String) {
    STORAGE(""),
    CAMERA(""),
    RECORD_AUDIO(""),
    ACCESS_FINE_LOCATION(""),
    ACCESS_COARSE_LOCATION(""),
    POST_NOTIFICATIONS(""),
    ACTIVITY_RECOGNITION(""),
    READ_PHONE_STATE(""),
    CALL_PHONE(""),
    READ_CALL_LOG(""),
    WRITE_CALL_LOG(""),
    ADD_VOICEMAIL(""),
    ANSWER_PHONE_CALLS(""),
    USE_SIP(""),
    READ_PHONE_NUMBERS(""),
    SEND_SMS(""),
    RECEIVE_SMS(""),
    RECEIVE_WAP_PUSH(""),
    READ_SMS(""),
    RECEIVE_MMS(""),
    READ_CALENDAR(""),
    WRITE_CALENDAR(""),
    READ_CONTACTS(""),
    WRITE_CONTACTS(""),
    GET_ACCOUNTS(""),
    ACCESS_MEDIA_LOCATION(""),
    BLUETOOTH(""),
}
