package network.chaintech.cmpeasypermission

import androidx.compose.runtime.Composable
import network.chaintech.cmpeasypermission.DialogParams
import network.chaintech.cmpeasypermission.MyAlertDialog
import platform.AVFAudio.AVAudioSession
import platform.AVFAudio.AVAudioSessionRecordPermission
import platform.AVFAudio.AVAudioSessionRecordPermissionDenied
import platform.AVFAudio.AVAudioSessionRecordPermissionGranted
import platform.AVFAudio.AVAudioSessionRecordPermissionUndetermined

@Composable
fun handleMicroPhoneAuthorizationStatus(
    deniedDialogParams: DialogParams?,
    onGranted: (Boolean) -> Unit,
    openSetting: Boolean
) {
    val status = AVAudioSession.sharedInstance().recordPermission
    when (status) {
        AVAudioSessionRecordPermissionGranted -> onGranted(true)
        AVAudioSessionRecordPermissionUndetermined -> requestMicroPhonePermission(onGranted)
        AVAudioSessionRecordPermissionDenied ->
            if (openSetting && deniedDialogParams != null) {
                MyAlertDialog(
                    dialogParams = deniedDialogParams,
                    onConfirmButtonClicked = {
                        onGranted(false)
                        openAppSettings()
                    },
                    onDismissButtonClicked = { onGranted(false) }
                )
            } else {
                onGranted(false)
            }

        else -> onGranted(false)
    }
}
private fun requestMicroPhonePermission(onGranted: (Boolean) -> Unit) {
    AVAudioSession.sharedInstance().requestRecordPermission { granted ->
        onGranted(granted)
    }
}
