package network.chaintech.cmpeasypermission

import androidx.compose.runtime.Composable
import network.chaintech.cmpeasypermission.DialogParams
import network.chaintech.cmpeasypermission.MyAlertDialog
import platform.AVFAudio.AVAudioSession
import platform.AVFAudio.AVAudioSessionRecordPermission
import platform.AVFAudio.AVAudioSessionRecordPermissionDenied
import platform.AVFAudio.AVAudioSessionRecordPermissionGranted
import platform.AVFAudio.AVAudioSessionRecordPermissionUndetermined
import platform.Contacts.CNAuthorizationStatusAuthorized
import platform.Contacts.CNAuthorizationStatusDenied
import platform.Contacts.CNAuthorizationStatusNotDetermined
import platform.Contacts.CNContactStore
import platform.Contacts.CNEntityType
import platform.CoreBluetooth.CBCentralManager
import platform.CoreBluetooth.CBCentralManagerStatePoweredOn
import platform.EventKit.EKAuthorizationStatusAuthorized
import platform.EventKit.EKAuthorizationStatusDenied
import platform.EventKit.EKAuthorizationStatusNotDetermined
import platform.EventKit.EKEntityType
import platform.EventKit.EKEventStore
import platform.Photos.PHAuthorizationStatusAuthorized
import platform.Photos.PHAuthorizationStatusDenied
import platform.Photos.PHAuthorizationStatusNotDetermined
import platform.Photos.PHAuthorizationStatusRestricted
import platform.Photos.PHPhotoLibrary
import platform.posix.`false`

@Composable
fun handleGalleryAuthorizationStatus(
    deniedDialogParams: DialogParams?,
    onGranted: (Boolean) -> Unit,
    openSetting: Boolean
) {
    val status = PHPhotoLibrary.authorizationStatus()
    when (status) {
        PHAuthorizationStatusAuthorized -> onGranted(true)
        PHAuthorizationStatusNotDetermined -> requestGalleryPermission(onGranted)
        PHAuthorizationStatusDenied, PHAuthorizationStatusRestricted -> if (openSetting && deniedDialogParams != null) {
            MyAlertDialog(
                dialogParams = deniedDialogParams,
                onConfirmButtonClicked = {
                    onGranted(false)
                    openAppSettings()
                },
                onDismissButtonClicked = { onGranted(false) }
            )
        } else {
            onGranted(false)
        }

        else -> {
            requestGalleryPermission(onGranted)
        }
    }
}

fun requestGalleryPermission(onGranted: (Boolean) -> Unit) {
    PHPhotoLibrary.requestAuthorization { status ->
        val granted = status == PHAuthorizationStatusAuthorized
        onGranted(granted)
    }
}
