package network.chaintech.cmpeasypermission

import androidx.compose.runtime.Composable
import network.chaintech.cmpeasypermission.DialogParams
import network.chaintech.cmpeasypermission.MyAlertDialog
import platform.AVFAudio.AVAudioSession
import platform.AVFAudio.AVAudioSessionRecordPermission
import platform.AVFAudio.AVAudioSessionRecordPermissionDenied
import platform.AVFAudio.AVAudioSessionRecordPermissionGranted
import platform.AVFAudio.AVAudioSessionRecordPermissionUndetermined
import platform.Contacts.CNAuthorizationStatusAuthorized
import platform.Contacts.CNAuthorizationStatusDenied
import platform.Contacts.CNAuthorizationStatusNotDetermined
import platform.Contacts.CNAuthorizationStatusRestricted
import platform.Contacts.CNContactStore
import platform.Contacts.CNEntityType
import platform.posix.`false`

@Composable
fun handleContactAuthorizationStatus(
    deniedDialogParams: DialogParams?,
    onGranted: (Boolean) -> Unit,
    openSetting: Boolean
) {
    val status = CNContactStore.authorizationStatusForEntityType(CNEntityType.CNEntityTypeContacts)
    return when (status) {
        CNAuthorizationStatusAuthorized -> onGranted(true)
        CNAuthorizationStatusDenied,
        CNAuthorizationStatusRestricted -> if (openSetting && deniedDialogParams != null) {
            MyAlertDialog(
                dialogParams = deniedDialogParams,
                onConfirmButtonClicked = {
                    onGranted(false)
                    openAppSettings()
                },
                onDismissButtonClicked = { onGranted(false) }
            )
        } else {
            onGranted(false)
        }
        CNAuthorizationStatusNotDetermined -> requestContactPermission(onGranted)
        else -> onGranted(false)
    }
}

fun requestContactPermission(onGranted: (Boolean) -> Unit) {
    val store = CNContactStore()
    store.requestAccessForEntityType(CNEntityType.CNEntityTypeContacts) { granted, _ ->
        onGranted(granted)
    }
}
