package network.chaintech.cmpeasypermission

import androidx.compose.runtime.Composable
import kotlinx.cinterop.ExportObjCClass
import network.chaintech.cmpeasypermission.DialogParams
import network.chaintech.cmpeasypermission.MyAlertDialog
import platform.AVFAudio.AVAudioSession
import platform.AVFAudio.AVAudioSessionRecordPermission
import platform.AVFAudio.AVAudioSessionRecordPermissionDenied
import platform.AVFAudio.AVAudioSessionRecordPermissionGranted
import platform.AVFAudio.AVAudioSessionRecordPermissionUndetermined
import platform.Contacts.CNAuthorizationStatusAuthorized
import platform.Contacts.CNAuthorizationStatusDenied
import platform.Contacts.CNAuthorizationStatusNotDetermined
import platform.Contacts.CNContactStore
import platform.Contacts.CNEntityType
import platform.CoreBluetooth.CBCentralManager
import platform.CoreBluetooth.CBCentralManagerDelegateProtocol
import platform.CoreBluetooth.CBCentralManagerStatePoweredOff
import platform.CoreBluetooth.CBCentralManagerStatePoweredOn
import platform.CoreBluetooth.CBCentralManagerStateResetting
import platform.CoreBluetooth.CBCentralManagerStateUnauthorized
import platform.CoreBluetooth.CBCentralManagerStateUnknown
import platform.CoreBluetooth.CBCentralManagerStateUnsupported
import platform.CoreBluetooth.CBManager
import platform.CoreBluetooth.CBManagerAuthorizationAllowedAlways
import platform.CoreBluetooth.CBManagerAuthorizationDenied
import platform.CoreBluetooth.CBManagerAuthorizationNotDetermined
import platform.CoreBluetooth.CBManagerAuthorizationRestricted
import platform.CoreLocation.CLLocationManager
import platform.CoreLocation.CLLocationManagerDelegateProtocol
import platform.EventKit.EKAuthorizationStatusAuthorized
import platform.EventKit.EKAuthorizationStatusDenied
import platform.EventKit.EKAuthorizationStatusNotDetermined
import platform.EventKit.EKEntityType
import platform.EventKit.EKEventStore
import platform.darwin.NSObject
import platform.posix.`false`


@ExportObjCClass
class BluetoothPermissionManager : NSObject(), CBCentralManagerDelegateProtocol {
    private var callBack: ((Boolean) -> Unit)? = null
    private var centralManager: CBCentralManager? = null
    init {
        centralManager = CBCentralManager(this, null)
    }

    @Composable
    fun handleBluetoothAuthorizationStatus(
        deniedDialogParams: DialogParams?,
        onGranted: (Boolean) -> Unit,
        openSetting: Boolean
    ) {
        when(CBManager.authorization) {
            CBManagerAuthorizationDenied,
            CBManagerAuthorizationRestricted -> if (openSetting && deniedDialogParams != null) {
                MyAlertDialog(
                    dialogParams = deniedDialogParams,
                    onConfirmButtonClicked = {
                        onGranted(false)
                        openAppSettings()
                    },
                    onDismissButtonClicked = { onGranted(false) }
                )
            } else {
                onGranted(false)
            }
            CBManagerAuthorizationAllowedAlways -> onGranted(true)
            CBManagerAuthorizationNotDetermined -> requestBluetoothPermission(onGranted)
            else -> onGranted(false)
        }
    }
    private fun requestBluetoothPermission(onGranted: (Boolean) -> Unit) {
        callBack = onGranted
        centralManager?.scanForPeripheralsWithServices(null, null)
    }

    override fun centralManagerDidUpdateState(central: CBCentralManager) {
        when (central.state) {
            CBCentralManagerStateUnknown ->  callBack?.let { it(false) }
            CBCentralManagerStateResetting -> callBack?.let { it(false) }
            CBCentralManagerStateUnsupported -> callBack?.let { it(false) }
            CBCentralManagerStateUnauthorized -> callBack?.let { it(false) }
            CBCentralManagerStatePoweredOff -> callBack?.let { it(false) }
            CBCentralManagerStatePoweredOn -> callBack?.let { it(true) }
            else -> callBack?.let { it(false) }
        }
    }
}