/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.sochain;

import java.util.List;
import network.arkane.provider.sochain.SoChainClient;
import network.arkane.provider.sochain.domain.BalanceResult;
import network.arkane.provider.sochain.domain.Network;
import network.arkane.provider.sochain.domain.SendSignedTransactionRequest;
import network.arkane.provider.sochain.domain.SendSignedTransactionResult;
import network.arkane.provider.sochain.domain.SoChainResult;
import network.arkane.provider.sochain.domain.Transaction;
import org.springframework.stereotype.Component;

@Component
public class SoChainGateway {
    private static final String USER_AGENT = "curl/7.54.0";
    private SoChainClient soChainClient;

    public SoChainGateway(SoChainClient soChainClient) {
        this.soChainClient = soChainClient;
    }

    public BalanceResult getBalance(Network network, String address) {
        return this.parseResult(this.soChainClient.getBalance(USER_AGENT, network.name(), address));
    }

    public List<Transaction> getUnspentTransactions(Network network, String address) {
        return this.parseResult(this.soChainClient.getUnspentTransactions(USER_AGENT, network.name(), address)).getTransactions();
    }

    public List<Transaction> getReceivedTransactions(Network network, String address) {
        return this.parseResult(this.soChainClient.getReceivedTransactions(USER_AGENT, network.name(), address)).getTransactions();
    }

    public List<Transaction> getSpentTransactions(Network network, String address) {
        return this.parseResult(this.soChainClient.getSpentTransactions(USER_AGENT, network.name(), address)).getTransactions();
    }

    public SendSignedTransactionResult sendSignedTransaction(Network network, String signedTransactionAsHex) {
        return this.parseResult(this.soChainClient.sendSignedTransaction(USER_AGENT, network.name(), new SendSignedTransactionRequest(signedTransactionAsHex)));
    }

    private <T> T parseResult(SoChainResult<T> result) {
        if (result.getStatus().equalsIgnoreCase("fail")) {
            throw new RuntimeException("Error when retrieving data from chain");
        }
        return result.getData();
    }
}

