/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.sochain;

import feign.Headers;
import network.arkane.provider.sochain.domain.BalanceResult;
import network.arkane.provider.sochain.domain.SendSignedTransactionRequest;
import network.arkane.provider.sochain.domain.SendSignedTransactionResult;
import network.arkane.provider.sochain.domain.SoChainResult;
import network.arkane.provider.sochain.domain.Transactions;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(name="chainso-client", url="https://chain.so/api/v2", decode404=true)
public interface SoChainClient {
    @RequestMapping(method={RequestMethod.GET}, value={"/get_address_balance/{network}/{address}"})
    public SoChainResult<BalanceResult> getBalance(@RequestHeader(value="User-Agent") String var1, @PathVariable(value="network") String var2, @PathVariable(value="address") String var3);

    @RequestMapping(method={RequestMethod.GET}, value={"/get_tx_unspent/{network}/{address}"})
    public SoChainResult<Transactions> getUnspentTransactions(@RequestHeader(value="User-Agent") String var1, @PathVariable(value="network") String var2, @PathVariable(value="address") String var3);

    @RequestMapping(method={RequestMethod.GET}, value={"/get_tx_received/{network}/{address}"})
    public SoChainResult<Transactions> getReceivedTransactions(@RequestHeader(value="User-Agent") String var1, @PathVariable(value="network") String var2, @PathVariable(value="address") String var3);

    @RequestMapping(method={RequestMethod.GET}, value={"/get_tx_spent/{network}/{address}"})
    public SoChainResult<Transactions> getSpentTransactions(@RequestHeader(value="User-Agent") String var1, @PathVariable(value="network") String var2, @PathVariable(value="address") String var3);

    @RequestMapping(method={RequestMethod.POST}, value={"/send_tx/{network}"})
    @Headers(value={"Content-Type: application/json"})
    public SoChainResult<SendSignedTransactionResult> sendSignedTransaction(@RequestHeader(value="User-Agent") String var1, @PathVariable(value="network") String var2, @RequestBody SendSignedTransactionRequest var3);
}

