/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.secret.generation;

import network.arkane.provider.chain.SecretType;
import network.arkane.provider.secret.generation.SecretGenerator;
import network.arkane.provider.secret.generation.VechainSecretKey;
import org.springframework.stereotype.Component;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;

@Component
public class VechainSecretGenerator
implements SecretGenerator<VechainSecretKey> {
    public VechainSecretKey generate() {
        try {
            ECKeyPair ecKeyPair = Keys.createEcKeyPair();
            return VechainSecretKey.builder().keyPair(ecKeyPair).build();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to generate vechain keypair");
        }
    }

    public SecretType type() {
        return SecretType.VECHAIN;
    }
}

