/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.core.model.clients;

import network.arkane.provider.core.model.exception.ClientArgumentException;
import network.arkane.provider.utils.BlockchainUtils;

public class Revision {
    public static final Revision BEST = new Revision();
    private String revision = "best";

    public static Revision create(long blockNumber) {
        Revision revision = new Revision();
        revision.revision = "" + blockNumber;
        return revision;
    }

    public static Revision create(String blockId) {
        if (blockId.equalsIgnoreCase("best")) {
            return BEST;
        }
        if (!BlockchainUtils.isId(blockId)) {
            throw ClientArgumentException.exception("create revision from blockId invalid");
        }
        Revision revision = new Revision();
        revision.revision = blockId;
        return revision;
    }

    private Revision() {
    }

    public String toString() {
        return this.revision;
    }
}

