/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.core.model.clients;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import network.arkane.provider.clients.TransactionClient;
import network.arkane.provider.core.model.blockchain.ContractCall;
import network.arkane.provider.core.model.clients.Address;
import network.arkane.provider.core.model.clients.ERC1155Contract;
import network.arkane.provider.core.model.clients.Revision;
import network.arkane.provider.core.model.clients.base.AbiDefinition;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.NumericType;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Uint256;

public class ERC1155ContractClient
extends TransactionClient {
    private static final Logger log = LoggerFactory.getLogger(ERC1155ContractClient.class);

    public static boolean isERC1155Contract(String contractAddress) {
        try {
            byte[] erc1155Bytes = Hex.decode((String)"d9b67a26");
            AbiDefinition abiDefinition = ERC1155Contract.defaultERC1155Contract.findAbiDefinition("supportsInterface");
            ContractCall call = ERC1155Contract.buildCall(abiDefinition, new Object[]{erc1155Bytes});
            return Boolean.valueOf(ERC1155ContractClient.callContract(call, Address.fromHexString(contractAddress), Revision.BEST).getData());
        }
        catch (Exception ex) {
            log.debug("Unable to fetch supportsInterface for {}", (Object)contractAddress);
            return false;
        }
    }

    public static List<BigInteger> balanceOf(String contractAddress, String owner, List<BigInteger> ids) {
        AbiDefinition abiDefinition = ERC1155Contract.defaultERC1155Contract.findAbiDefinition("balanceOfBatch");
        String[] owners = IntStream.range(0, ids.size()).mapToObj(x -> owner).collect(Collectors.toList()).toArray(new String[0]);
        ContractCall call = ERC1155Contract.buildCall(abiDefinition, owners, ids.toArray());
        String data = ERC1155ContractClient.callContract(call, Address.fromHexString(contractAddress), Revision.BEST).getData();
        Function f = new Function("balanceOfBatch", Arrays.asList(new DynamicArray(Arrays.stream(owners).map(org.web3j.abi.datatypes.Address::new).collect(Collectors.toList())), new DynamicArray(ids.stream().map(Uint256::new).collect(Collectors.toList()))), Arrays.asList(new TypeReference<DynamicArray<Uint256>>(){}));
        return ((ArrayList)((Type)FunctionReturnDecoder.decode((String)data, (List)f.getOutputParameters()).get(0)).getValue()).stream().map(NumericType::getValue).collect(Collectors.toList());
    }
}

