/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.contract;

import java.io.IOException;
import java.util.List;
import network.arkane.provider.clients.base.AbstractClient;
import network.arkane.provider.contract.ContractService;
import network.arkane.provider.contract.EvmContractService;
import network.arkane.provider.core.model.blockchain.ContractCall;
import network.arkane.provider.core.model.blockchain.ContractCallResult;
import network.arkane.provider.core.model.clients.Address;
import network.arkane.provider.core.model.clients.Revision;
import network.arkane.provider.gateway.VechainGateway;
import org.springframework.stereotype.Component;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;

@Component
public class VechainContractService
extends EvmContractService
implements ContractService {
    private VechainGateway vechainGateway;

    public VechainContractService(VechainGateway vechainGateway) {
        this.vechainGateway = vechainGateway;
    }

    List<Type> executeContractCall(String from, String to, Function function) {
        String data = FunctionEncoder.encode((Function)function);
        ContractCall contractCall = new ContractCall();
        contractCall.setCaller(from);
        contractCall.setData(data);
        contractCall.setValue("0x0");
        try {
            ContractCallResult result = AbstractClient.callContract(contractCall, Address.fromHexString(to), Revision.BEST);
            return FunctionReturnDecoder.decode((String)result.getData(), (List)function.getOutputParameters());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

