/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.utils;

import java.util.ArrayList;
import java.util.List;
import network.arkane.provider.BytesUtils;
import network.arkane.provider.core.model.blockchain.RawClause;
import network.arkane.provider.core.model.clients.RawTransaction;
import network.arkane.provider.utils.StringUtils;
import network.arkane.provider.utils.rlp.RlpDecoder;
import network.arkane.provider.utils.rlp.RlpEncoder;
import network.arkane.provider.utils.rlp.RlpList;
import network.arkane.provider.utils.rlp.RlpString;
import network.arkane.provider.utils.rlp.RlpType;

public class RLPUtils {
    private static final int Chain_Tag = 0;
    private static final int Block_Ref = 1;
    private static final int Expiration = 2;
    private static final int Clauses = 3;
    private static final int GasPriceCoef = 4;
    private static final int Gas = 5;
    private static final int DependsOn = 6;
    private static final int Nonce = 7;
    private static final int Reserved = 8;
    private static final int Signature = 9;
    private static final int To = 0;
    private static final int Value = 1;
    private static final int Data = 2;

    public static byte[] encodeRawTransaction(RawTransaction rawTransaction) {
        List<RlpType> values = RLPUtils.asRlpValues(rawTransaction);
        RlpList rlpList = new RlpList(values);
        return RlpEncoder.encode(rlpList);
    }

    private static List<RlpType> asRlpValues(RawTransaction rawTransaction) {
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        if (rawTransaction.getChainTag() == 0) {
            throw new IllegalArgumentException("getChainTag is null");
        }
        result.add(RlpString.create(rawTransaction.getChainTag()));
        if (rawTransaction.getBlockRef() == null) {
            throw new IllegalArgumentException("getBlockRef is null");
        }
        result.add(RlpString.create(rawTransaction.getBlockRef()));
        if (rawTransaction.getExpiration() == null) {
            throw new IllegalArgumentException("getExpiration is null");
        }
        result.add(RlpString.create(rawTransaction.getExpiration()));
        List<RlpType> clauses = RLPUtils.buildRlpClausesLIst(rawTransaction);
        RlpList rlpList = new RlpList(clauses);
        result.add(rlpList);
        if (rawTransaction.getGasPriceCoef() == 0) {
            result.add(RlpString.create(RlpString.EMPTY));
        } else {
            result.add(RlpString.create(rawTransaction.getGasPriceCoef()));
        }
        if (rawTransaction.getGas() == null) {
            throw new IllegalArgumentException("getGas is null");
        }
        result.add(RlpString.create(rawTransaction.getGas()));
        if (rawTransaction.getDependsOn() == null) {
            result.add(RlpString.create(RlpString.EMPTY));
        } else {
            result.add(RlpString.create(rawTransaction.getDependsOn()));
        }
        if (rawTransaction.getNonce() == null) {
            throw new IllegalArgumentException("getNonce is null");
        }
        result.add(RlpString.create(rawTransaction.getNonce()));
        if (rawTransaction.getReserved() != null) {
            throw new IllegalArgumentException("reservedList is not supported");
        }
        ArrayList<RlpType> reservedRlp = new ArrayList<RlpType>();
        RlpList reservedList = new RlpList(reservedRlp);
        result.add(reservedList);
        if (rawTransaction.getSignature() != null) {
            result.add(RlpString.create(rawTransaction.getSignature()));
        }
        return result;
    }

    private static List<RlpType> buildRlpClausesLIst(RawTransaction rawTransaction) {
        ArrayList<RlpType> clauses = new ArrayList<RlpType>();
        for (RawClause clause : rawTransaction.getClauses()) {
            ArrayList<RlpType> rlpClause = new ArrayList<RlpType>();
            if (clause.getTo() == null) {
                rlpClause.add(RlpString.create(RlpString.EMPTY));
            } else {
                rlpClause.add(RlpString.create(clause.getTo()));
            }
            if (clause.getValue() == null) {
                rlpClause.add(RlpString.create(RlpString.EMPTY));
            } else {
                rlpClause.add(RlpString.create(clause.getValue()));
            }
            if (clause.getData() == null) {
                rlpClause.add(RlpString.create(RlpString.EMPTY));
            } else {
                rlpClause.add(RlpString.create(clause.getData()));
            }
            RlpList clauseRLP = new RlpList(rlpClause);
            clauses.add(clauseRLP);
        }
        return clauses;
    }

    public static RawTransaction decode(String hexRawTransaction) {
        if (!StringUtils.isHex(hexRawTransaction)) {
            return null;
        }
        byte[] rawTxBytes = BytesUtils.toByteArray((String)hexRawTransaction);
        RlpList list = RlpDecoder.decode(rawTxBytes);
        if (list == null) {
            return null;
        }
        List<RlpType> rlpContent = list.getValues();
        if (rlpContent.size() != 1) {
            return null;
        }
        RawTransaction rawTransaction = new RawTransaction();
        List<RlpType> listValues = ((RlpList)rlpContent.get(0)).getValues();
        for (int index = 0; index < listValues.size(); ++index) {
            RLPUtils.fillTransaction(rawTransaction, listValues, index);
        }
        return rawTransaction;
    }

    private static void fillTransaction(RawTransaction rawTransaction, List listValues, int index) {
        switch (index) {
            case 0: {
                RlpString rlpString = (RlpString)listValues.get(index);
                rawTransaction.setChainTag(rlpString.getBytes()[0]);
                break;
            }
            case 1: {
                RlpString rlpString = (RlpString)listValues.get(index);
                rawTransaction.setBlockRef(rlpString.getBytes());
                break;
            }
            case 2: {
                RlpString rlpString = (RlpString)listValues.get(index);
                rawTransaction.setExpiration(rlpString.getBytes());
                break;
            }
            case 3: {
                RlpList clauseList = (RlpList)listValues.get(index);
                RLPUtils.fillClauses(rawTransaction, clauseList);
                break;
            }
            case 4: {
                RlpString rlpString = (RlpString)listValues.get(index);
                if (rlpString.getBytes().length == 0) {
                    rawTransaction.setGasPriceCoef((byte)0);
                    break;
                }
                rawTransaction.setGasPriceCoef(rlpString.getBytes()[0]);
                break;
            }
            case 5: {
                RlpString rlpString = (RlpString)listValues.get(index);
                rawTransaction.setGas(rlpString.getBytes());
                break;
            }
            case 6: {
                RlpString rlpString = (RlpString)listValues.get(index);
                if (rlpString.getBytes().length == 0) {
                    rawTransaction.setDependsOn(null);
                    break;
                }
                rawTransaction.setDependsOn(rlpString.getBytes());
                break;
            }
            case 7: {
                RlpString rlpString = (RlpString)listValues.get(index);
                rawTransaction.setNonce(rlpString.getBytes());
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                RlpString rlpString = (RlpString)listValues.get(index);
                rawTransaction.setSignature(rlpString.getBytes());
            }
        }
    }

    private static void fillClauses(RawTransaction rawTransaction, RlpList list) {
        List<RlpType> clauses = list.getValues();
        int clausesSize = clauses.size();
        RawClause[] rawClause = new RawClause[clausesSize];
        rawTransaction.setClauses(rawClause);
        for (int clauseIndex = 0; clauseIndex < clausesSize; ++clauseIndex) {
            List<RlpType> clauseContent = ((RlpList)clauses.get(clauseIndex)).getValues();
            rawClause[clauseIndex] = new RawClause();
            RLPUtils.fillOneClause(rawClause, clauseIndex, clauseContent);
        }
    }

    private static void fillOneClause(RawClause[] rawClause, int clauseIndex, List<RlpType> clauseContent) {
        block5: for (int index = 0; index < clauseContent.size(); ++index) {
            RlpString clause = (RlpString)clauseContent.get(index);
            switch (index) {
                case 0: {
                    rawClause[clauseIndex].setTo(clause.getBytes());
                    continue block5;
                }
                case 1: {
                    rawClause[clauseIndex].setValue(clause.getBytes());
                    continue block5;
                }
                case 2: {
                    rawClause[clauseIndex].setData(clause.getBytes());
                }
            }
        }
    }
}

