package network.arkane.provider.core.model.clients;

import network.arkane.provider.core.model.clients.base.AbiDefinition;
import network.arkane.provider.core.model.clients.base.AbstractContract;

import java.math.BigInteger;

public class ERC1155Contract extends AbstractContract {
    private static final String ERC1155ABIString = "[\n"
                                                   + "    {\n"
                                                   + "      \"constant\": true,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_owner\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_id\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"balanceOf\",\n"
                                                   + "      \"outputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"view\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": true,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_interfaceId\",\n"
                                                   + "          \"type\": \"bytes4\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"supportsInterface\",\n"
                                                   + "      \"outputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"\",\n"
                                                   + "          \"type\": \"bool\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"view\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": true,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"maxIndex\",\n"
                                                   + "      \"outputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"view\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": false,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_from\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_to\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_ids\",\n"
                                                   + "          \"type\": \"uint256[]\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_values\",\n"
                                                   + "          \"type\": \"uint256[]\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_data\",\n"
                                                   + "          \"type\": \"bytes\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"safeBatchTransferFrom\",\n"
                                                   + "      \"outputs\": [],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"nonpayable\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": true,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_owners\",\n"
                                                   + "          \"type\": \"address[]\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_ids\",\n"
                                                   + "          \"type\": \"uint256[]\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"balanceOfBatch\",\n"
                                                   + "      \"outputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"\",\n"
                                                   + "          \"type\": \"uint256[]\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"view\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": true,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_id\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"isNonFungibleItem\",\n"
                                                   + "      \"outputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"\",\n"
                                                   + "          \"type\": \"bool\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"pure\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": true,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_id\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"ownerOf\",\n"
                                                   + "      \"outputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"view\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": true,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_id\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"getNonFungibleBaseType\",\n"
                                                   + "      \"outputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"pure\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": true,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_id\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"isNonFungibleBaseType\",\n"
                                                   + "      \"outputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"\",\n"
                                                   + "          \"type\": \"bool\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"pure\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": true,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_id\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"getNonFungibleIndex\",\n"
                                                   + "      \"outputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"pure\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": false,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_operator\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_approved\",\n"
                                                   + "          \"type\": \"bool\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"setApprovalForAll\",\n"
                                                   + "      \"outputs\": [],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"nonpayable\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": true,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_id\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"isFungible\",\n"
                                                   + "      \"outputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"\",\n"
                                                   + "          \"type\": \"bool\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"pure\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": true,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"creators\",\n"
                                                   + "      \"outputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"view\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": true,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_id\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"isNonFungible\",\n"
                                                   + "      \"outputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"\",\n"
                                                   + "          \"type\": \"bool\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"pure\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": true,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_owner\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_operator\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"isApprovedForAll\",\n"
                                                   + "      \"outputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"\",\n"
                                                   + "          \"type\": \"bool\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"view\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": false,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_from\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_to\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_id\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_value\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_data\",\n"
                                                   + "          \"type\": \"bytes\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"safeTransferFrom\",\n"
                                                   + "      \"outputs\": [],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"nonpayable\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"anonymous\": false,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"indexed\": true,\n"
                                                   + "          \"name\": \"_operator\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"indexed\": true,\n"
                                                   + "          \"name\": \"_from\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"indexed\": true,\n"
                                                   + "          \"name\": \"_to\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"indexed\": false,\n"
                                                   + "          \"name\": \"_id\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"indexed\": false,\n"
                                                   + "          \"name\": \"_value\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"TransferSingle\",\n"
                                                   + "      \"type\": \"event\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"anonymous\": false,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"indexed\": true,\n"
                                                   + "          \"name\": \"_operator\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"indexed\": true,\n"
                                                   + "          \"name\": \"_from\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"indexed\": true,\n"
                                                   + "          \"name\": \"_to\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"indexed\": false,\n"
                                                   + "          \"name\": \"_ids\",\n"
                                                   + "          \"type\": \"uint256[]\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"indexed\": false,\n"
                                                   + "          \"name\": \"_values\",\n"
                                                   + "          \"type\": \"uint256[]\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"TransferBatch\",\n"
                                                   + "      \"type\": \"event\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"anonymous\": false,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"indexed\": true,\n"
                                                   + "          \"name\": \"_owner\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"indexed\": true,\n"
                                                   + "          \"name\": \"_operator\",\n"
                                                   + "          \"type\": \"address\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"indexed\": false,\n"
                                                   + "          \"name\": \"_approved\",\n"
                                                   + "          \"type\": \"bool\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"ApprovalForAll\",\n"
                                                   + "      \"type\": \"event\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"anonymous\": false,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"indexed\": false,\n"
                                                   + "          \"name\": \"_value\",\n"
                                                   + "          \"type\": \"string\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"indexed\": true,\n"
                                                   + "          \"name\": \"_id\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"URI\",\n"
                                                   + "      \"type\": \"event\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": false,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_uri\",\n"
                                                   + "          \"type\": \"string\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_isNF\",\n"
                                                   + "          \"type\": \"bool\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"create\",\n"
                                                   + "      \"outputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_type\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"nonpayable\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": false,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_type\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_to\",\n"
                                                   + "          \"type\": \"address[]\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"mintNonFungible\",\n"
                                                   + "      \"outputs\": [],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"nonpayable\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    },\n"
                                                   + "    {\n"
                                                   + "      \"constant\": false,\n"
                                                   + "      \"inputs\": [\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_id\",\n"
                                                   + "          \"type\": \"uint256\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_to\",\n"
                                                   + "          \"type\": \"address[]\"\n"
                                                   + "        },\n"
                                                   + "        {\n"
                                                   + "          \"name\": \"_quantities\",\n"
                                                   + "          \"type\": \"uint256[]\"\n"
                                                   + "        }\n"
                                                   + "      ],\n"
                                                   + "      \"name\": \"mintFungible\",\n"
                                                   + "      \"outputs\": [],\n"
                                                   + "      \"payable\": false,\n"
                                                   + "      \"stateMutability\": \"nonpayable\",\n"
                                                   + "      \"type\": \"function\"\n"
                                                   + "    }\n"
                                                   + "  ]";


    public ERC1155Contract() {
        super(ERC1155ABIString);
    }

    public static final ERC1155Contract defaultERC1155Contract = new ERC1155Contract();

    public static String createType(final String tokenURI, final boolean nonFungible) {
        final AbiDefinition abiDefinition = ERC1155Contract.defaultERC1155Contract.findAbiDefinition("create");
        return buildData(abiDefinition,
                  tokenURI,
                  nonFungible);
    }

    public static String mintFungible(final BigInteger type,
                               final String[] to,
                               final BigInteger[] amount) {
        final AbiDefinition abiDefinition = ERC1155Contract.defaultERC1155Contract.findAbiDefinition("mintFungible");
        return buildData(abiDefinition,
                         type,
                         to,
                         amount);
    }

    public static String mintNonFungible(final BigInteger type,
                                  final String[] to) {
        final AbiDefinition abiDefinition = ERC1155Contract.defaultERC1155Contract.findAbiDefinition("mintNonFungible");
        return buildData(abiDefinition,
                         type,
                         to);
    }
}
