/*
 * Decompiled with CFR 0.152.
 */
package network.arkane.provider.sign;

import java.nio.charset.StandardCharsets;
import network.arkane.provider.exceptions.ArkaneException;
import network.arkane.provider.secret.generation.VechainSecretKey;
import network.arkane.provider.sign.Signer;
import network.arkane.provider.sign.VechainRawSignable;
import network.arkane.provider.sign.domain.HexSignature;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Sign;

@Component
public class VechainRawSigner
implements Signer<VechainRawSignable, VechainSecretKey> {
    private static final Logger log = LoggerFactory.getLogger(VechainRawSigner.class);
    private static final String MESSAGE_PREFIX = "\u0019Vechain Signed Message:\n";

    public HexSignature createSignature(VechainRawSignable signable, VechainSecretKey key) {
        try {
            byte[] dataToSign;
            log.debug("Signing raw ethereum transaction: {}", (Object)signable.toString());
            if (signable.getData() != null && this.isHexadecimal(signable.getData())) {
                try {
                    dataToSign = Hex.decodeHex((String)signable.getData().replaceFirst("0x", ""));
                }
                catch (DecoderException de) {
                    dataToSign = signable.getData().getBytes(StandardCharsets.UTF_8);
                }
            } else {
                byte[] byArray = dataToSign = signable.getData() == null ? "".getBytes(StandardCharsets.UTF_8) : signable.getData().getBytes(StandardCharsets.UTF_8);
            }
            Sign.SignatureData signatureData = signable.isPrefix() ? this.signPrefixedMessage(dataToSign, key.getKeyPair()) : (signable.isHash() ? Sign.signMessage((byte[])dataToSign, (ECKeyPair)key.getKeyPair()) : Sign.signMessage((byte[])dataToSign, (ECKeyPair)key.getKeyPair(), (boolean)false));
            return HexSignature.builder().r(signatureData.getR()).s(signatureData.getS()).v((int)signatureData.getV()).build();
        }
        catch (Exception ex) {
            log.error("Unable to sign transaction: {}", (Object)ex.getMessage());
            throw ArkaneException.arkaneException().errorCode("transaction.sign.internal-error").errorCode("A problem occurred trying to sign the raw Ethereum object").cause((Throwable)ex).build();
        }
    }

    private Sign.SignatureData signPrefixedMessage(byte[] message, ECKeyPair keyPair) {
        return Sign.signMessage((byte[])this.getVechainMessageHash(message), (ECKeyPair)keyPair, (boolean)false);
    }

    private byte[] getVechainMessageHash(byte[] message) {
        byte[] prefix = this.getVechainMessagePrefix(message.length);
        byte[] result = new byte[prefix.length + message.length];
        System.arraycopy(prefix, 0, result, 0, prefix.length);
        System.arraycopy(message, 0, result, prefix.length, message.length);
        return Hash.sha3((byte[])result);
    }

    private byte[] getVechainMessagePrefix(int messageLength) {
        return MESSAGE_PREFIX.concat(String.valueOf(messageLength)).getBytes();
    }
}

